/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.grid.fluid;

import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import resonant.lib.utility.WorldUtility;
import resonantinduction.core.grid.fluid.FluidDistributionetwork;
import resonantinduction.core.grid.fluid.IFluidDistribution;
import resonantinduction.core.grid.fluid.TileFluidNode;
import universalelectricity.api.net.INodeNetwork;
import universalelectricity.api.vector.Vector3;

public abstract class TileFluidDistribution
extends TileFluidNode
implements IFluidDistribution {
    protected Object[] connectedBlocks = new Object[6];
    protected FluidDistributionetwork network;

    public TileFluidDistribution(Material material, int tankSize) {
        super(material, tankSize);
    }

    public void initiate() {
        super.initiate();
        this.refresh();
        ((FluidDistributionetwork)((Object)this.getNetwork())).reconstruct();
    }

    protected void onNeighborChanged() {
        this.refresh();
    }

    public void func_70313_j() {
        ((FluidDistributionetwork)((Object)this.getNetwork())).split(this);
        super.func_70313_j();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return ((FluidDistributionetwork)((Object)this.getNetwork())).fill(this, from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return ((FluidDistributionetwork)((Object)this.getNetwork())).drain((IFluidDistribution)this, from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return ((FluidDistributionetwork)((Object)this.getNetwork())).drain((IFluidDistribution)this, from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{((FluidDistributionetwork)((Object)this.getNetwork())).getTank().getInfo()};
    }

    public Object[] getConnections() {
        return this.connectedBlocks;
    }

    public void refresh() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            byte previousConnections = this.renderSides;
            this.connectedBlocks = new Object[6];
            this.renderSides = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.validateConnectionSide(new Vector3((TileEntity)this).translate(dir).getTileEntity((IBlockAccess)this.field_70331_k), dir);
            }
            if (previousConnections != this.renderSides) {
                ((FluidDistributionetwork)((Object)this.getNetwork())).update();
                ((FluidDistributionetwork)((Object)this.getNetwork())).reconstruct();
                this.sendRenderUpdate();
            }
        }
    }

    public void validateConnectionSide(TileEntity tileEntity, ForgeDirection side) {
        if (!this.field_70331_k.field_72995_K && tileEntity instanceof IFluidDistribution) {
            ((FluidDistributionetwork)((Object)this.getNetwork())).merge((INodeNetwork)((IFluidDistribution)tileEntity).getNetwork());
            this.renderSides = WorldUtility.setEnableSide((byte)this.renderSides, (ForgeDirection)side, (boolean)true);
            this.connectedBlocks[side.ordinal()] = tileEntity;
        }
    }

    public int getSubID() {
        return this.colorID;
    }

    public void setSubID(int id) {
        this.colorID = id;
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        return true;
    }

    public IFluidDistribution getInstance(ForgeDirection from) {
        return this;
    }
}

