/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.core.ResonantInduction;

public abstract class RITemplateRecipeHandler
extends TemplateRecipeHandler {
    int[][] inputSlots = new int[][]{{11, 5}, {29, 5}, {11, 23}, {29, 23}, {11, 41}, {29, 41}};
    int[][] outputSlots = new int[][]{{121, 5}, {139, 5}, {121, 23}, {139, 23}, {121, 41}, {139, 41}};

    public abstract String getRecipeName();

    public abstract ResonantInduction.RecipeType getMachine();

    public String getOverlayIdentifier() {
        return this.getMachine().name().toLowerCase();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(57, 26, 52, 22), this.getMachine().name().toLowerCase(), new Object[0]));
    }

    public int recipiesPerPage() {
        return 2;
    }

    public String getGuiTexture() {
        return "resonantinduction:textures/gui/gui_machine.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Map.Entry<RecipeResource[], RecipeResource[]> entry : MachineRecipes.INSTANCE.getRecipes(this.getMachine().name()).entrySet()) {
                CachedRIRecipe recipe = new CachedRIRecipe(entry);
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void drawExtras(int recipeID) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        TemplateRecipeHandler.CachedRecipe cachedRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeID);
        if (cachedRecipe instanceof CachedRIRecipe) {
            FluidStack fluid;
            int i;
            CachedRIRecipe recipe = (CachedRIRecipe)cachedRecipe;
            for (i = 0; i < recipe.inputFluids.length && (fluid = recipe.inputFluids[i]) != null; ++i) {
                gui.func_94065_a(this.inputSlots[i][0], this.inputSlots[i][1], fluid.getFluid().getIcon(), 16, 16);
            }
            for (i = 0; i < recipe.outputFluids.length && (fluid = recipe.outputFluids[i]) != null; ++i) {
                gui.func_94065_a(this.outputSlots[i][0], this.outputSlots[i][1], fluid.getFluid().getIcon(), 16, 16);
            }
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipeID) {
        if (currenttip.size() == 0) {
            Point offset = gui.getRecipePosition(recipeID);
            Point mouse = GuiDraw.getMousePosition();
            TemplateRecipeHandler.CachedRecipe cachedRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeID);
            if (cachedRecipe instanceof CachedRIRecipe) {
                Rectangle rect;
                FluidStack fluid;
                int i;
                CachedRIRecipe recipe = (CachedRIRecipe)cachedRecipe;
                for (i = 0; i < recipe.inputFluids.length && (fluid = recipe.inputFluids[i]) != null; ++i) {
                    rect = new Rectangle(offset.x + this.inputSlots[i][0] - 1, offset.y + this.inputSlots[i][1] - 1, 18, 18);
                    if (!rect.contains(mouse)) continue;
                    currenttip.add(fluid.getFluid().getLocalizedName());
                    currenttip.add(LanguageUtility.getLocal((String)"tooltip.ri.amount").replace("%s", fluid.amount + ""));
                    return currenttip;
                }
                for (i = 0; i < recipe.outputFluids.length && (fluid = recipe.outputFluids[i]) != null; ++i) {
                    rect = new Rectangle(offset.x + this.outputSlots[i][0] - 1, offset.y + this.outputSlots[i][1] - 1, 18, 18);
                    if (!rect.contains(mouse)) continue;
                    currenttip.add(fluid.getFluid().getLocalizedName());
                    currenttip.add(LanguageUtility.getLocal((String)"tooltip.ri.amount").replace("%s", fluid.amount + ""));
                    return currenttip;
                }
            }
        }
        return currenttip;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<RecipeResource[], RecipeResource[]> entry : MachineRecipes.INSTANCE.getRecipes(this.getMachine().name()).entrySet()) {
            CachedRIRecipe recipe = new CachedRIRecipe(entry);
            if (!recipe.canProduce(result)) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals(this.getOverlayIdentifier())) {
            for (Map.Entry<RecipeResource[], RecipeResource[]> entry : MachineRecipes.INSTANCE.getRecipes(this.getMachine().name()).entrySet()) {
                CachedRIRecipe recipe = new CachedRIRecipe(entry);
                this.arecipes.add(recipe);
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<RecipeResource[], RecipeResource[]> entry : MachineRecipes.INSTANCE.getRecipes(this.getMachine().name()).entrySet()) {
            CachedRIRecipe recipe = new CachedRIRecipe(entry);
            if (!recipe.doesUse(ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    public class CachedRIRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private RecipeResource[] inputResources;
        private RecipeResource[] outputResources;
        private List<PositionedStack> inputs;
        private List<PositionedStack> outputs;
        final FluidStack[] inputFluids;
        final FluidStack[] outputFluids;

        public List<PositionedStack> getOtherStacks() {
            if (this.outputs != null && !this.outputs.isEmpty()) {
                return this.outputs;
            }
            int i = 0;
            this.outputs = new ArrayList<PositionedStack>();
            for (RecipeResource output : this.outputResources) {
                if (output instanceof RecipeResource.ItemStackResource) {
                    this.outputs.add(new PositionedStack((Object)((RecipeResource.ItemStackResource)output).itemStack, RITemplateRecipeHandler.this.outputSlots[i][0], RITemplateRecipeHandler.this.outputSlots[i++][1]));
                } else if (output instanceof RecipeResource.OreDictResource) {
                    this.outputs.add(new PositionedStack((Object)OreDictionary.getOres((String)((RecipeResource.OreDictResource)output).name), RITemplateRecipeHandler.this.outputSlots[i][0], RITemplateRecipeHandler.this.outputSlots[i++][1]));
                } else if (output instanceof RecipeResource.FluidStackResource) {
                    this.outputFluids[i++] = ((RecipeResource.FluidStackResource)output).fluidStack;
                }
                this.outputs.get(this.outputs.size() - 1).generatePermutations();
            }
            return this.outputs;
        }

        public List<PositionedStack> getIngredients() {
            if (this.inputs != null && !this.inputs.isEmpty()) {
                return this.inputs;
            }
            int i = 0;
            this.inputs = new ArrayList<PositionedStack>();
            for (RecipeResource input : this.inputResources) {
                if (input instanceof RecipeResource.ItemStackResource) {
                    this.inputs.add(new PositionedStack((Object)((RecipeResource.ItemStackResource)input).itemStack, RITemplateRecipeHandler.this.inputSlots[i][0], RITemplateRecipeHandler.this.inputSlots[i++][1]));
                } else if (input instanceof RecipeResource.OreDictResource) {
                    this.inputs.add(new PositionedStack((Object)OreDictionary.getOres((String)((RecipeResource.OreDictResource)input).name), RITemplateRecipeHandler.this.inputSlots[i][0], RITemplateRecipeHandler.this.inputSlots[i++][1]));
                } else if (input instanceof RecipeResource.FluidStackResource) {
                    this.inputFluids[i++] = ((RecipeResource.FluidStackResource)input).fluidStack;
                }
                if (this.inputs.size() <= 0) continue;
                this.inputs.get(this.inputs.size() - 1).generatePermutations();
            }
            return this.inputs;
        }

        public CachedRIRecipe(Map.Entry<RecipeResource[], RecipeResource[]> recipe) {
            super((TemplateRecipeHandler)RITemplateRecipeHandler.this);
            this.inputs = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.inputFluids = new FluidStack[RITemplateRecipeHandler.this.inputSlots.length];
            this.outputFluids = new FluidStack[RITemplateRecipeHandler.this.outputSlots.length];
            this.inputResources = recipe.getKey();
            this.outputResources = recipe.getValue();
        }

        public PositionedStack getResult() {
            return null;
        }

        public boolean canProduce(ItemStack product) {
            boolean canProduce = false;
            this.getOtherStacks();
            for (int i = 0; i < this.outputResources.length; ++i) {
                RecipeResource rStack = this.outputResources[i];
                if (!rStack.equals(product)) continue;
                this.outputs.get((int)i).item = product;
                canProduce = true;
            }
            return canProduce;
        }

        public boolean doesUse(ItemStack input) {
            boolean doesUse = false;
            this.getIngredients();
            for (int i = 0; i < this.inputResources.length; ++i) {
                RecipeResource rStack = this.inputResources[i];
                if (!rStack.equals(input)) continue;
                this.inputs.get((int)i).item = input;
                doesUse = true;
            }
            return doesUse;
        }
    }
}

