/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.imprint;

import java.util.HashSet;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IFilterable;
import resonant.api.IRotatable;
import resonant.lib.content.module.prefab.TileInventory;
import resonantinduction.core.prefab.imprint.ItemImprint;
import universalelectricity.api.vector.Vector3;

public abstract class TileFilterable
extends TileInventory
implements IRotatable,
IFilterable {
    private ItemStack filterItem;
    private boolean inverted;
    public static final int FILTER_SLOT = 0;
    public static final int BATERY_DRAIN_SLOT = 1;

    public TileFilterable() {
        super(null);
        this.maxSlots = 2;
    }

    public TileFilterable(Material material) {
        super(material);
        this.maxSlots = 2;
    }

    protected boolean isFunctioning() {
        return true;
    }

    public boolean use(EntityPlayer player, int side, Vector3 hit) {
        ItemStack containingStack = this.getFilter();
        if (containingStack != null) {
            if (!this.world().field_72995_K) {
                EntityItem dropStack = new EntityItem(this.world(), player.field_70165_t, player.field_70163_u, player.field_70161_v, containingStack);
                dropStack.field_70293_c = 0;
                this.world().func_72838_d((Entity)dropStack);
            }
            this.setFilter(null);
            return true;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemImprint) {
            this.setFilter(player.func_71045_bC());
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            return true;
        }
        return false;
    }

    public boolean configure(EntityPlayer player, int side, Vector3 hit) {
        this.toggleInversion();
        this.markUpdate();
        this.markRender();
        return true;
    }

    public boolean isFiltering(ItemStack itemStack) {
        HashSet<ItemStack> checkStacks;
        if (this.getFilter() != null && itemStack != null && (checkStacks = ItemImprint.getFilters(this.getFilter())) != null) {
            for (ItemStack stack : checkStacks) {
                if (!stack.func_77969_a(itemStack)) continue;
                return !this.inverted;
            }
        }
        return this.inverted;
    }

    public void setFilter(ItemStack filter) {
        this.filterItem = filter;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public ItemStack getFilter() {
        return this.filterItem;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void toggleInversion() {
        this.setInverted(!this.isInverted());
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)(this.func_70311_o() != null ? this.func_70322_n() : 0));
    }

    public void setDirection(ForgeDirection facingDirection) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, facingDirection.ordinal(), 3);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("inverted", this.inverted);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        if (nbt.func_74764_b("filter")) {
            this.getInventory().func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("filter")));
        }
        this.inverted = nbt.func_74767_n("inverted");
    }
}

