/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.items;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import resonant.lib.render.EnumColor;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.nbt.NBTUtility;
import resonantinduction.core.prefab.items.ItemTool;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalClass;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.energy.UnitDisplay;
import universalelectricity.api.item.IEnergyItem;
import universalelectricity.api.item.IVoltageItem;

@UniversalClass
public class ItemEnergyTool
extends ItemTool
implements IEnergyItem,
IVoltageItem {
    protected long batterySize = 500000L;
    protected boolean hasTier = false;
    protected boolean showEnergy = true;
    protected int energyTiers = 0;

    public ItemEnergyTool(int id) {
        super(id);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        if (this.hasTier) {
            list.add(LanguageUtility.getLocal((String)"tooltip.tier") + ": " + (ItemEnergyTool.getTier(itemStack) + 1));
        }
        if (this.showEnergy) {
            String color = "";
            long joules = this.getEnergy(itemStack);
            color = joules <= this.getEnergyCapacity(itemStack) / 3L ? "\u00a74" : (joules > this.getEnergyCapacity(itemStack) * 2L / 3L ? "\u00a72" : "\u00a76");
            list.add(LanguageUtility.getLocal((String)"tooltip.battery.energy").replace("%0", color).replace("%1", EnumColor.GREY.toString()).replace("%v0", UnitDisplay.getDisplayShort((double)joules, (UnitDisplay.Unit)UnitDisplay.Unit.JOULES)).replace("%v1", UnitDisplay.getDisplayShort((double)this.getEnergyCapacity(itemStack), (UnitDisplay.Unit)UnitDisplay.Unit.JOULES)));
        }
    }

    @Override
    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77622_d(itemStack, world, player);
        this.setEnergy(itemStack, 0L);
    }

    public long recharge(ItemStack itemStack, long energy, boolean doReceive) {
        long rejectedElectricity = Math.max(this.getEnergy(itemStack) + energy - this.getEnergyCapacity(itemStack), 0L);
        long energyToReceive = Math.min(energy - rejectedElectricity, this.getTransferRate(itemStack));
        if (doReceive) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public long discharge(ItemStack itemStack, long energy, boolean doTransfer) {
        long energyToExtract = Math.min(Math.min(this.getEnergy(itemStack), energy), this.getTransferRate(itemStack));
        if (doTransfer) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) - energyToExtract);
        }
        return energyToExtract;
    }

    public long getVoltage(ItemStack itemStack) {
        return UniversalElectricity.DEFAULT_VOLTAGE;
    }

    public void setEnergy(ItemStack itemStack, long joules) {
        long electricityStored = Math.max(Math.min(joules, this.getEnergyCapacity(itemStack)), 0L);
        NBTUtility.getNBTTagCompound((ItemStack)itemStack).func_74772_a("electricity", electricityStored);
    }

    public long getEnergySpace(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) - this.getEnergy(itemStack);
    }

    public long getEnergy(ItemStack itemStack) {
        return NBTUtility.getNBTTagCompound((ItemStack)itemStack).func_74763_f("electricity");
    }

    public int getDisplayDamage(ItemStack stack) {
        return (int)(100.0 - (double)this.getEnergy(stack) / (double)this.getEnergyCapacity(stack) * 100.0);
    }

    public long getEnergyCapacity(ItemStack theItem) {
        return this.batterySize;
    }

    public long getTransferRate(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) / 100L;
    }

    public static ItemStack setTier(ItemStack itemStack, int tier) {
        NBTUtility.getNBTTagCompound((ItemStack)itemStack).func_74774_a("tier", (byte)tier);
        return itemStack;
    }

    public static byte getTier(ItemStack itemStack) {
        return NBTUtility.getNBTTagCompound((ItemStack)itemStack).func_74771_c("tier");
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i >= 0 && i < this.energyTiers; ++i) {
            par3List.add(CompatibilityModule.getItemWithCharge((ItemStack)ItemEnergyTool.setTier(new ItemStack((Item)this), i), (long)0L));
            par3List.add(CompatibilityModule.getItemWithCharge((ItemStack)ItemEnergyTool.setTier(new ItemStack((Item)this), i), (long)this.getEnergyCapacity(ItemEnergyTool.setTier(new ItemStack((Item)this), i))));
        }
    }
}

