/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.TMultiPart;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import resonantinduction.core.MultipartUtility;
import resonantinduction.core.prefab.part.PartAdvanced;

public abstract class PartColorableMaterial<M extends Enum>
extends PartAdvanced {
    public static final int DEFAULT_COLOR = 15;
    public int color = 15;
    public M material;
    public boolean isInsulated = false;
    public boolean requiresInsulation = true;
    protected final Item insulationType;

    public PartColorableMaterial(Item insulationType) {
        this.insulationType = insulationType;
    }

    public M getMaterial() {
        return this.material;
    }

    public void setMaterial(M material) {
        this.material = material;
    }

    public abstract void setMaterial(int var1);

    public int getMaterialID() {
        return ((Enum)this.material).ordinal();
    }

    public void setInsulated(boolean insulated) {
        this.isInsulated = insulated;
        this.color = 15;
        if (!this.world().field_72995_K) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.sendInsulationUpdate();
        }
    }

    public void setInsulated(int dyeColour) {
        this.isInsulated = true;
        this.color = dyeColour;
        if (!this.world().field_72995_K) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.sendInsulationUpdate();
            this.sendColorUpdate();
        }
    }

    public boolean isInsulated() {
        return this.isInsulated;
    }

    public void sendInsulationUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(1).writeBoolean(this.isInsulated);
    }

    public int getColor() {
        return this.isInsulated || !this.requiresInsulation ? this.color : -1;
    }

    public void setColor(int dye) {
        if (this.isInsulated || !this.requiresInsulation) {
            this.color = dye;
            if (!this.world().field_72995_K) {
                this.tile().notifyPartChange((TMultiPart)this);
                this.onPartChanged(this);
                this.sendColorUpdate();
            }
        }
    }

    public void sendColorUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(2).writeInt(this.color);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack itemStack) {
        if (itemStack != null) {
            int dyeColor = MultipartUtility.isDye(itemStack);
            if (dyeColor != -1 && (this.isInsulated() || !this.requiresInsulation)) {
                if (!player.field_71075_bZ.field_75098_d && this.requiresInsulation) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
                this.setColor(dyeColor);
                return true;
            }
            if (this.requiresInsulation) {
                if (itemStack.func_77973_b() == this.insulationType) {
                    if (this.isInsulated()) {
                        if (!this.world().field_72995_K && player.field_71075_bZ.field_75098_d) {
                            this.tile().dropItems(Collections.singletonList(new ItemStack(this.insulationType, 1, BlockColored.func_72238_e_((int)this.color))));
                        }
                        this.setInsulated(false);
                        return true;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    this.setInsulated(BlockColored.func_72239_d((int)itemStack.func_77960_j()));
                    return true;
                }
                if (itemStack.func_77973_b() instanceof ItemShears && this.isInsulated()) {
                    if (!this.world().field_72995_K && !player.field_71075_bZ.field_75098_d) {
                        this.tile().dropItems(Collections.singletonList(new ItemStack(this.insulationType, 1, BlockColored.func_72238_e_((int)this.color))));
                    }
                    this.setInsulated(false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItem());
        if (this.requiresInsulation && this.isInsulated) {
            drops.add(new ItemStack(this.insulationType, 1, BlockColored.func_72238_e_((int)this.color)));
        }
        return drops;
    }

    public void readDesc(MCDataInput packet) {
        this.setMaterial(packet.readByte());
        this.color = packet.readByte();
        this.isInsulated = packet.readBoolean();
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)((byte)this.getMaterialID()));
        packet.writeByte((int)((byte)this.color));
        packet.writeBoolean(this.isInsulated);
    }

    public void read(MCDataInput packet, int packetID) {
        switch (packetID) {
            case 1: {
                this.isInsulated = packet.readBoolean();
                this.tile().markRender();
                break;
            }
            case 2: {
                this.color = packet.readInt();
                this.tile().markRender();
            }
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("typeID", this.getMaterialID());
        nbt.func_74757_a("isInsulated", this.isInsulated);
        nbt.func_74768_a("dyeID", this.color);
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.setMaterial(nbt.func_74762_e("typeID"));
        this.isInsulated = nbt.func_74767_n("isInsulated");
        this.color = nbt.func_74762_e("dyeID");
    }
}

