/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.microblock.IHollowConnect;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.grid.INode;
import resonant.api.grid.INodeProvider;
import resonant.lib.grid.Node;
import resonantinduction.core.prefab.part.PartColorableMaterial;

public abstract class PartFramedNode<M extends Enum, N extends Node, T extends INodeProvider>
extends PartColorableMaterial<M>
implements INodeProvider,
TSlottedPart,
JNormalOcclusion,
IHollowConnect,
JIconHitEffects {
    public static IndexedCuboid6[] sides = new IndexedCuboid6[7];
    public static IndexedCuboid6[] insulatedSides = new IndexedCuboid6[7];
    protected Object[] connections = new Object[6];
    protected N node;
    public byte currentConnections = 0;
    private ForgeDirection testingSide;
    @SideOnly(value=Side.CLIENT)
    protected Icon breakIcon;

    public PartFramedNode(Item insulationType) {
        super(insulationType);
    }

    public void preparePlacement(int meta) {
        this.setMaterial(meta);
    }

    public boolean occlusionTest(TMultiPart other) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)other);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        IndexedCuboid6[] currentSides;
        HashSet<IndexedCuboid6> subParts = new HashSet<IndexedCuboid6>();
        IndexedCuboid6[] indexedCuboid6Array = currentSides = this.isInsulated() ? insulatedSides : sides;
        if (this.tile() != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int ord = side.ordinal();
                if (!PartFramedNode.connectionMapContainsSide(this.getAllCurrentConnections(), side) && side != this.testingSide) continue;
                subParts.add(currentSides[ord]);
            }
        }
        subParts.add(currentSides[6]);
        return subParts;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        HashSet<Cuboid6> collisionBoxes = new HashSet<Cuboid6>();
        collisionBoxes.addAll((Collection)this.getSubParts());
        return collisionBoxes;
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return 10.0f;
    }

    public void drawBreaking(RenderBlocks renderBlocks) {
        if (this.breakIcon != null) {
            CCRenderState.reset();
            RenderUtils.renderBlock((Cuboid6)sides[6], (int)0, (Transformation)new Translation((double)this.x(), (double)this.y(), (double)this.z()), (IUVTransformation)new IconTransformation(this.breakIcon), null);
        }
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    }

    public Icon getBreakingIcon(Object subPart, int side) {
        return this.breakIcon;
    }

    public Icon getBrokenIcon(int side) {
        return this.breakIcon;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    public int getHollowSize() {
        return this.isInsulated ? 8 : 6;
    }

    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    public void addDestroyEffects(EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    public boolean isBlockedOnSide(ForgeDirection side) {
        TMultiPart blocker = this.tile().partMap(side.ordinal());
        this.testingSide = side;
        boolean expandable = NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)blocker);
        this.testingSide = null;
        return !expandable;
    }

    public byte getAllCurrentConnections() {
        return this.currentConnections;
    }

    public static boolean connectionMapContainsSide(byte connections, ForgeDirection side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    public void bind(TileMultipart t) {
        this.node.deconstruct();
        super.bind(t);
        this.node.reconstruct();
    }

    public boolean isCurrentlyConnected(ForgeDirection side) {
        return PartFramedNode.connectionMapContainsSide(this.getAllCurrentConnections(), side);
    }

    public void onWorldJoin() {
        this.node.reconstruct();
    }

    public void onNeighborChanged() {
        this.node.reconstruct();
    }

    public void onWorldSeparate() {
        this.node.deconstruct();
    }

    public void copyFrom(PartFramedNode<M, N, T> other) {
        this.isInsulated = other.isInsulated;
        this.color = other.color;
        this.connections = other.connections;
        this.material = other.material;
    }

    public void sendConnectionUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeByte((int)this.currentConnections);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.currentConnections = packet.readByte();
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.currentConnections);
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    @Override
    public void read(MCDataInput packet, int packetID) {
        if (packetID == 0) {
            this.currentConnections = packet.readByte();
            this.tile().markRender();
        } else {
            super.read(packet, packetID);
        }
    }

    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (this.node != null && nodeType != null && nodeType.isAssignableFrom(this.node.getClass())) {
            return this.node;
        }
        return null;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        this.node.save(nbt);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.node.load(nbt);
    }

    static {
        PartFramedNode.sides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.36, 0.0, 0.36, 0.64, 0.36, 0.64));
        PartFramedNode.sides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.36, 0.64, 0.36, 0.64, 1.0, 0.64));
        PartFramedNode.sides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.36, 0.36, 0.0, 0.64, 0.64, 0.36));
        PartFramedNode.sides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.36, 0.36, 0.64, 0.64, 0.64, 1.0));
        PartFramedNode.sides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.36, 0.36, 0.36, 0.64, 0.64));
        PartFramedNode.sides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.64, 0.36, 0.36, 1.0, 0.64, 0.64));
        PartFramedNode.sides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.36, 0.36, 0.36, 0.64, 0.64, 0.64));
        PartFramedNode.insulatedSides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.3, 0.0, 0.3, 0.7, 0.3, 0.7));
        PartFramedNode.insulatedSides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.3, 0.7, 0.3, 0.7, 1.0, 0.7));
        PartFramedNode.insulatedSides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.3, 0.3, 0.0, 0.7, 0.7, 0.3));
        PartFramedNode.insulatedSides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.3, 0.3, 0.7, 0.7, 0.7, 1.0));
        PartFramedNode.insulatedSides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.3, 0.3, 0.3, 0.7, 0.7));
        PartFramedNode.insulatedSides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.7, 0.3, 0.3, 1.0, 0.7, 0.7));
        PartFramedNode.insulatedSides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.3, 0.3, 0.3, 0.7, 0.7, 0.7));
    }
}

