/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.resource;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.lib.prefab.block.BlockTile;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.resource.ItemOreResource;
import resonantinduction.core.resource.ResourceGenerator;
import resonantinduction.core.resource.TileDust;
import resonantinduction.core.resource.TileMaterial;

public class BlockDust
extends BlockTile {
    int nextDropMaterialID = 0;

    public BlockDust(int id) {
        super(id, Material.field_76251_o);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setBlockBoundsForDepth(0);
        this.func_71848_c(0.5f);
        this.func_111022_d("resonantinduction:material_sand");
        this.func_71884_a(field_71964_f);
    }

    public static boolean canFallBelow(World par0World, int par1, int par2, int par3) {
        int l = par0World.func_72798_a(par1, par2, par3);
        if (par0World.func_72799_c(par1, par2, par3)) {
            return true;
        }
        if (l == Block.field_72067_ar.field_71990_ca) {
            return true;
        }
        Material material = Block.field_71973_m[l].field_72018_cp;
        return material == Material.field_76244_g ? true : material == Material.field_76256_h;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess access, int x, int y, int z) {
        TileEntity tileEntity = access.func_72796_p(x, y, z);
        if (tileEntity instanceof TileMaterial) {
            return ((TileMaterial)tileEntity).getColor();
        }
        return 0xFFFFFF;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase par5EntityLivingBase, ItemStack itemStack) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileMaterial) {
            ((TileMaterial)tileEntity).name = ItemOreResource.getMaterialFromStack(itemStack);
        }
    }

    public void func_85105_g(World world, int x, int y, int z, int metadata) {
        this.tryToFall(world, x, y, z);
    }

    public void func_71861_g(World world, int x, int y, int z) {
        this.tryToFall(world, x, y, z);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        this.tryToFall(world, x, y, z);
    }

    private void tryToFall(World world, int x, int y, int z) {
        String materialName;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMaterial && (materialName = ((TileMaterial)tile).name) != null) {
            int metadata = world.func_72805_g(x, y, z);
            if (BlockDust.canFallBelow(world, x, y - 1, z) && y >= 0) {
                world.func_94571_i(x, y, z);
                while (BlockDust.canFallBelow(world, x, y - 1, z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    world.func_72832_d(x, y, z, this.field_71990_ca, metadata, 3);
                    TileEntity newTile = world.func_72796_p(x, y, z);
                    if (newTile instanceof TileMaterial) {
                        ((TileMaterial)newTile).name = materialName;
                    }
                }
            }
        }
    }

    public TileEntity func_72274_a(World var1) {
        return new TileDust();
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72805_g(par2, par3, par4) & 7;
        float f = 0.125f;
        return AxisAlignedBB.func_72332_a().func_72299_a((double)par2 + this.field_72026_ch, (double)par3 + this.field_72023_ci, (double)par4 + this.field_72024_cj, (double)par2 + this.field_72021_ck, (double)((float)par3 + (float)l * f), (double)par4 + this.field_72019_cm);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71919_f() {
        this.setBlockBoundsForDepth(0);
    }

    public void func_71902_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setBlockBoundsForDepth(par1IBlockAccess.func_72805_g(par2, par3, par4));
    }

    protected void setBlockBoundsForDepth(int par1) {
        int j = par1 & 7;
        float f = (float)(2 * (1 + j)) / 16.0f;
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return this == ResonantInduction.blockRefinedDust ? ResonantInduction.itemRefinedDust.field_77779_bT : ResonantInduction.itemDust.field_77779_bT;
    }

    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return this == ResonantInduction.blockRefinedDust ? ResonantInduction.itemRefinedDust.field_77779_bT : ResonantInduction.itemDust.field_77779_bT;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileMaterial) {
            this.nextDropMaterialID = ResourceGenerator.getID(((TileMaterial)tileEntity).name);
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public int func_71873_h(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileMaterial) {
            return ResourceGenerator.getID(((TileMaterial)tileEntity).name);
        }
        return this.func_71899_b(0);
    }

    public int func_71899_b(int par1) {
        return this.nextDropMaterialID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return par5 == 1 ? true : super.func_71877_c(par1IBlockAccess, par2, par3, par4, par5);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return (meta & 7) + 1;
    }
}

