/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.resource;

import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import resonant.api.recipe.MachineRecipes;
import resonant.lib.config.Config;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.nbt.IVirtualObject;
import resonant.lib.utility.nbt.NBTUtility;
import resonant.lib.utility.nbt.SaveManager;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.Settings;
import resonantinduction.core.fluid.FluidColored;
import resonantinduction.core.resource.OreDetectionBlackList;
import resonantinduction.core.resource.fluid.BlockFluidMaterial;
import resonantinduction.core.resource.fluid.BlockFluidMixture;

public class ResourceGenerator
implements IVirtualObject {
    public static final ResourceGenerator INSTANCE = new ResourceGenerator();
    public static final HashBiMap<String, Integer> materials = HashBiMap.create();
    static final HashMap<String, Integer> materialColorCache = new HashMap();
    static final HashMap<Icon, Integer> iconColorCache = new HashMap();
    @Config(category="Resource_Generator", key="Enable_All")
    public static boolean ENABLED;
    @Config(category="Resource_Generator", key="Enabled_All_Fluids")
    public static boolean ENABLE_FLUIDS;
    static int maxID;
    @Config(comment="Allow the Resource Generator to make ore dictionary compatible recipes?")
    private static boolean allowOreDictCompatibility;

    public static void generate(String materialName) {
        String nameCaps = LanguageUtility.capitalizeFirst((String)materialName);
        String localizedName = materialName;
        ArrayList list = OreDictionary.getOres((String)("ingot" + nameCaps));
        if (list.size() > 0) {
            ItemStack type = (ItemStack)list.get(0);
            localizedName = type.func_82833_r().trim();
            if (LanguageUtility.getLocal((String)localizedName) != null && LanguageUtility.getLocal((String)localizedName) != "") {
                localizedName = LanguageUtility.getLocal((String)localizedName);
            }
            localizedName.replace(LanguageUtility.getLocal((String)"misc.resonantinduction.ingot"), "").replaceAll("^ ", "").replaceAll(" $", "");
        }
        if (ENABLE_FLUIDS) {
            FluidColored fluidMolten = new FluidColored(ResourceGenerator.materialNameToMolten(materialName));
            fluidMolten.setDensity(7);
            fluidMolten.setViscosity(5000);
            fluidMolten.setTemperature(1811);
            FluidRegistry.registerFluid((Fluid)fluidMolten);
            LanguageRegistry.instance().addStringLocalization(fluidMolten.getUnlocalizedName(), LanguageUtility.getLocal((String)"tooltip.molten") + " " + localizedName);
            BlockFluidMaterial blockFluidMaterial = new BlockFluidMaterial(fluidMolten);
            GameRegistry.registerBlock((Block)blockFluidMaterial, (String)("molten" + nameCaps));
            ResonantInduction.blockMoltenFluid.put(ResourceGenerator.getID(materialName), blockFluidMaterial);
            FluidContainerRegistry.registerFluidContainer((Fluid)fluidMolten, (ItemStack)ResonantInduction.itemBucketMolten.getStackFromMaterial(materialName));
            FluidColored fluidMixture = new FluidColored(ResourceGenerator.materialNameToMixture(materialName));
            FluidRegistry.registerFluid((Fluid)fluidMixture);
            BlockFluidMixture blockFluidMixture = new BlockFluidMixture(fluidMixture);
            LanguageRegistry.instance().addStringLocalization(fluidMixture.getUnlocalizedName(), localizedName + " " + LanguageUtility.getLocal((String)"tooltip.mixture"));
            GameRegistry.registerBlock((Block)blockFluidMixture, (String)("mixture" + nameCaps));
            ResonantInduction.blockMixtureFluids.put(ResourceGenerator.getID(materialName), blockFluidMixture);
            FluidContainerRegistry.registerFluidContainer((Fluid)fluidMixture, (ItemStack)ResonantInduction.itemBucketMixture.getStackFromMaterial(materialName));
            if (allowOreDictCompatibility) {
                MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.SMELTER.name(), (Object)new FluidStack((Fluid)fluidMolten, 1000), new Object[]{"ingot" + nameCaps});
            } else {
                MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.SMELTER.name(), (Object)new FluidStack((Fluid)fluidMolten, 1000), new Object[]{"ingot" + nameCaps});
            }
        }
        ItemStack dust = ResonantInduction.itemDust.getStackFromMaterial(materialName);
        ItemStack rubble = ResonantInduction.itemRubble.getStackFromMaterial(materialName);
        ItemStack refinedDust = ResonantInduction.itemRefinedDust.getStackFromMaterial(materialName);
        if (allowOreDictCompatibility) {
            OreDictionary.registerOre((String)("rubble" + nameCaps), (ItemStack)ResonantInduction.itemRubble.getStackFromMaterial(materialName));
            OreDictionary.registerOre((String)("dirtyDust" + nameCaps), (ItemStack)ResonantInduction.itemDust.getStackFromMaterial(materialName));
            OreDictionary.registerOre((String)("dust" + nameCaps), (ItemStack)ResonantInduction.itemRefinedDust.getStackFromMaterial(materialName));
            MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.GRINDER.name(), (Object)("rubble" + nameCaps), new Object[]{dust, dust});
            MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.MIXER.name(), (Object)("dirtyDust" + nameCaps), new Object[]{refinedDust});
        } else {
            MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.GRINDER.name(), (Object)rubble, new Object[]{dust, dust});
            MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.MIXER.name(), (Object)dust, new Object[]{refinedDust});
        }
        FurnaceRecipes.func_77602_a().addSmelting(dust.field_77993_c, dust.func_77960_j(), ((ItemStack)OreDictionary.getOres((String)("ingot" + nameCaps)).get(0)).func_77946_l(), 0.7f);
        ItemStack smeltResult = ((ItemStack)OreDictionary.getOres((String)("ingot" + nameCaps)).get(0)).func_77946_l();
        FurnaceRecipes.func_77602_a().addSmelting(refinedDust.field_77993_c, refinedDust.func_77960_j(), smeltResult, 0.7f);
        if (OreDictionary.getOres((String)("ore" + nameCaps)).size() > 0) {
            MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.CRUSHER.name(), (Object)("ore" + nameCaps), new Object[]{"rubble" + nameCaps});
        }
    }

    public static void generateOreResources() {
        OreDictionary.registerOre((String)"ingotGold", (Item)Item.field_77717_p);
        OreDictionary.registerOre((String)"ingotIron", (Item)Item.field_77703_o);
        OreDictionary.registerOre((String)"oreGold", (Block)Block.field_71941_G);
        OreDictionary.registerOre((String)"oreIron", (Block)Block.field_71949_H);
        OreDictionary.registerOre((String)"oreLapis", (Block)Block.field_71947_N);
        MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.SMELTER.name(), (Object)new FluidStack(FluidRegistry.LAVA, 1000), new Object[]{new ItemStack(Block.field_71981_t)});
        MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.CRUSHER.name(), (Object)Block.field_71978_w, new Object[]{Block.field_71940_F});
        MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.CRUSHER.name(), (Object)Block.field_71981_t, new Object[]{Block.field_71978_w});
        MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.CRUSHER.name(), (Object)Block.field_72077_au, new Object[]{new ItemStack(Block.field_71988_x, 7, 0)});
        MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.GRINDER.name(), (Object)Block.field_71978_w, new Object[]{Block.field_71939_E});
        MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.GRINDER.name(), (Object)Block.field_71940_F, new Object[]{Block.field_71939_E});
        MachineRecipes.INSTANCE.addRecipe(ResonantInduction.RecipeType.GRINDER.name(), (Object)Block.field_71946_M, new Object[]{Block.field_71939_E});
        Iterator it = materials.keySet().iterator();
        while (it.hasNext()) {
            String materialName = (String)it.next();
            String nameCaps = LanguageUtility.capitalizeFirst((String)materialName);
            if (OreDictionary.getOres((String)("ore" + nameCaps)).size() > 0) {
                ResourceGenerator.generate(materialName);
                continue;
            }
            it.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void computeColors() {
        for (String material : materials.keySet()) {
            boolean totalR = false;
            boolean totalG = false;
            boolean totalB = false;
            boolean colorCount = false;
            for (ItemStack ingotStack : OreDictionary.getOres((String)("ingot" + LanguageUtility.capitalizeFirst((String)material)))) {
                Item theIngot = ingotStack.func_77973_b();
                int color = ResourceGenerator.getAverageColor(ingotStack);
                materialColorCache.put(material, color);
            }
            if (materialColorCache.containsKey(material)) continue;
            materialColorCache.put(material, 0xFFFFFF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getAverageColor(ItemStack itemStack) {
        int totalR = 0;
        int totalG = 0;
        int totalB = 0;
        int colorCount = 0;
        Item item = itemStack.func_77973_b();
        try {
            Icon icon = item.func_77650_f(itemStack);
            if (iconColorCache.containsKey(icon)) {
                return iconColorCache.get(icon);
            }
            String iconString = icon.func_94215_i();
            if (iconString != null && !iconString.contains("MISSING_ICON_ITEM")) {
                iconString = (iconString.contains(":") ? iconString.replace(":", ":textures/items/") : "textures/items/" + iconString) + ".png";
                ResourceLocation textureLocation = new ResourceLocation(iconString);
                InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(textureLocation).func_110527_b();
                BufferedImage bufferedimage = ImageIO.read(inputstream);
                int width = bufferedimage.getWidth();
                int height = bufferedimage.getWidth();
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        Color rgb = new Color(bufferedimage.getRGB(x, y));
                        double luma = 0.2126 * (double)rgb.getRed() + 0.7152 * (double)rgb.getGreen() + 0.0722 * (double)rgb.getBlue();
                        if (!(luma > 40.0)) continue;
                        totalR += rgb.getRed();
                        totalG += rgb.getGreen();
                        totalB += rgb.getBlue();
                        ++colorCount;
                    }
                }
            }
            if (colorCount > 0) {
                int averageColor = new Color(totalR /= colorCount, totalG /= colorCount, totalB /= colorCount).brighter().getRGB();
                iconColorCache.put(icon, averageColor);
                return averageColor;
            }
        }
        catch (Exception e) {
            ResonantInduction.LOGGER.fine("Failed to compute colors for: " + item);
        }
        return 0xFFFFFF;
    }

    public static String moltenToMaterial(String fluidName) {
        return ResourceGenerator.fluidNameToMaterial(fluidName, "molten");
    }

    public static String materialNameToMolten(String fluidName) {
        return ResourceGenerator.materialNameToFluid(fluidName, "molten");
    }

    public static String mixtureToMaterial(String fluidName) {
        return ResourceGenerator.fluidNameToMaterial(fluidName, "mixture");
    }

    public static String materialNameToMixture(String fluidName) {
        return ResourceGenerator.materialNameToFluid(fluidName, "mixture");
    }

    public static String fluidNameToMaterial(String fluidName, String type) {
        return LanguageUtility.decapitalizeFirst((String)LanguageUtility.underscoreToCamel((String)fluidName).replace(type, ""));
    }

    public static String materialNameToFluid(String materialName, String type) {
        return type + "_" + LanguageUtility.camelToLowerUnderscore((String)materialName);
    }

    public static BlockFluidFinite getMixture(String name) {
        return ResonantInduction.blockMixtureFluids.get(ResourceGenerator.getID(name));
    }

    public static BlockFluidFinite getMolten(String name) {
        return ResonantInduction.blockMoltenFluid.get(ResourceGenerator.getID(name));
    }

    public static int getID(String name) {
        if (!materials.containsKey((Object)name)) {
            ResonantInduction.LOGGER.severe("Trying to get invalid material name " + name);
            return 0;
        }
        return (Integer)materials.get((Object)name);
    }

    public static String getName(int id) {
        return (String)materials.inverse().get((Object)id);
    }

    public static String getName(ItemStack itemStack) {
        return LanguageUtility.decapitalizeFirst((String)OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)).replace("dirtyDust", "").replace("dust", "").replace("ore", "").replace("ingot", ""));
    }

    public static int getColor(String name) {
        if (name != null && materialColorCache.containsKey(name)) {
            return materialColorCache.get(name);
        }
        return 0xFFFFFF;
    }

    @Deprecated
    public static List<String> getMaterials() {
        ArrayList<String> returnMaterials = new ArrayList<String>();
        for (int i = 0; i < materials.size(); ++i) {
            returnMaterials.add(ResourceGenerator.getName(i));
        }
        return returnMaterials;
    }

    @ForgeSubscribe
    public void oreRegisterEvent(OreDictionary.OreRegisterEvent evt) {
        String oreDictName;
        String materialName;
        if (evt.Name.startsWith("ingot") && !materials.containsKey((Object)(materialName = LanguageUtility.decapitalizeFirst((String)(oreDictName = evt.Name.replace("ingot", "")))))) {
            Settings.CONFIGURATION.load();
            boolean allowMaterial = Settings.CONFIGURATION.get("Resource_Generator", "Enable " + oreDictName, true).getBoolean(true);
            Settings.CONFIGURATION.save();
            if (!allowMaterial || OreDetectionBlackList.isIngotBlackListed("ingot" + oreDictName) || OreDetectionBlackList.isOreBlackListed("ore" + oreDictName)) {
                return;
            }
            materials.put((Object)materialName, (Object)maxID++);
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void reloadTextures(TextureStitchEvent.Post e) {
        ResourceGenerator.computeColors();
    }

    public void save(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : materials.entrySet()) {
            NBTTagCompound node = new NBTTagCompound();
            node.func_74778_a("materialName", (String)entry.getKey());
            node.func_74768_a("materialID", ((Integer)entry.getValue()).intValue());
            list.func_74742_a((NBTBase)node);
        }
        nbt.func_74782_a("materialIDMap", (NBTBase)list);
    }

    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("materialIDMap")) {
            materials.clear();
            NBTTagList nbtList = nbt.func_74761_m("materialIDMap");
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                NBTTagCompound node = (NBTTagCompound)nbtList.func_74743_b(i);
                materials.put((Object)node.func_74779_i("materialName"), (Object)node.func_74762_e("materialID"));
            }
        }
    }

    public File getSaveFile() {
        return new File(NBTUtility.getSaveDirectory(), "Resource_Generator.dat");
    }

    public void setSaveFile(File file) {
    }

    static {
        OreDetectionBlackList.addIngot("ingotRefinedIron");
        OreDetectionBlackList.addIngot("ingotUranium");
        SaveManager.registerClass((String)"resourceGenerator", ResourceGenerator.class);
        SaveManager.register((Object)INSTANCE);
        ENABLED = true;
        ENABLE_FLUIDS = true;
        maxID = 0;
        allowOreDictCompatibility = true;
    }
}

