/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Map;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.illumination.LanternPart;
import mrtjp.projectred.illumination.RenderHalo;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderLantern
implements IItemRenderer {
    public static RenderLantern instance = new RenderLantern();
    private static Map<String, CCModel> models;
    public static final Cuboid6 lightBox;
    public static ms[] onIcons;
    public static ms[] offIcons;

    public static void registerIcons(mt reg) {
        int i;
        offIcons = new ms[16];
        for (i = 0; i < 16; ++i) {
            RenderLantern.offIcons[i] = reg.a("projectred:lights/lanternoff/" + i);
        }
        onIcons = new ms[16];
        for (i = 0; i < 16; ++i) {
            RenderLantern.onIcons[i] = reg.a("projectred:lights/lanternon/" + i);
        }
    }

    public void renderLantern(LanternPart l) {
        ms icon = l.isOn() ? onIcons[l.type] : offIcons[l.type];
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.setBrightness((acf)l.world(), (int)l.x(), (int)l.y(), (int)l.z());
        CCRenderState.useModelColours((boolean)true);
        this.renderLanternBulb(icon, l.x(), l.y(), l.z(), l.side);
    }

    public void renderLanternBulb(ms icon, double x, double y, double z, int rotation) {
        this.renderPart(icon, models.get("bulb"), x, y, z, 2);
        if (rotation == 0) {
            this.renderPart(icon, models.get("standbottom"), x, y, z, 2);
            this.renderPart(icon, models.get("goldringbottom"), x, y, z, 2);
        } else if (rotation == 1) {
            this.renderPart(icon, models.get("standtop"), x, y, z, 2);
            this.renderPart(icon, models.get("goldringtop"), x, y, z, 2);
        } else {
            this.renderPart(icon, models.get("standside"), x, y, z, rotation);
            this.renderPart(icon, models.get("goldringtop"), x, y, z, rotation);
        }
    }

    public boolean handleRenderType(ye item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ye item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ye item, Object ... data) {
        boolean on = item.b() == ProjectRedIllumination.itemPartInvLantern;
        int color = item.k();
        switch (type) {
            case ENTITY: {
                this.renderInventory(on, color, -0.25, 0.0, -0.25, 1.0);
                return;
            }
            case EQUIPPED: {
                this.renderInventory(on, color, -0.15, -0.15, -0.15, 2.0);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderInventory(on, color, -0.15, -0.15, -0.15, 2.0);
                return;
            }
            case INVENTORY: {
                this.renderInventory(on, color, 0.0, -0.05, 0.0, 2.0);
                return;
            }
        }
    }

    public void renderInventory(boolean on, int color, double x, double y, double z, double scale) {
        ms icon = on ? onIcons[color] : offIcons[color];
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        CCRenderState.reset();
        TextureUtils.bindAtlas((int)0);
        CCRenderState.useNormals((boolean)true);
        CCRenderState.startDrawing((int)7);
        this.renderPart(icon, models.get("bulb"), x, y, z, 2);
        this.renderPart(icon, models.get("goldringtop"), x, y, z, 2);
        CCRenderState.draw();
        if (on) {
            RenderHalo.prepareRenderState();
            RenderHalo.renderHalo(bfq.a, lightBox, color, (Transformation)new Translation(x, y, z));
            RenderHalo.restoreRenderState();
        }
        GL11.glPopMatrix();
    }

    public void renderPart(ms icon, CCModel cc, double x, double y, double z, int rot) {
        cc.render(0, cc.verts.length, (Transformation)Rotation.sideOrientation((int)0, (int)Rotation.rotationTo((int)0, (int)rot)).at(Vector3.center).with((Transformation)new Translation(x, y, z)), (IUVTransformation)new IconTransformation(icon), null);
    }

    static {
        lightBox = new Cuboid6(0.35, 0.25, 0.35, 0.65, 0.75, 0.65).expand(-0.015625);
        models = CCModel.parseObjModels((bjo)new bjo("projectred", "textures/obj/lights/lantern.obj"), (int)7, (Transformation)new InvertX());
        for (CCModel c : models.values()) {
            c.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            c.computeLighting(LightModel.standardLightModel);
            c.shrinkUVs(5.0E-4);
        }
    }
}

