/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.render.RenderBlockFluidClassic;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.entity.EntityFishingRod;
import powercrystals.minefactoryreloaded.entity.EntityNeedle;
import powercrystals.minefactoryreloaded.entity.EntityPinkSlime;
import powercrystals.minefactoryreloaded.entity.EntityRocket;
import powercrystals.minefactoryreloaded.entity.EntitySafariNet;
import powercrystals.minefactoryreloaded.item.ItemRocketLauncher;
import powercrystals.minefactoryreloaded.render.RenderTickHandler;
import powercrystals.minefactoryreloaded.render.block.ConveyorRenderer;
import powercrystals.minefactoryreloaded.render.block.DetCordRenderer;
import powercrystals.minefactoryreloaded.render.block.FactoryGlassPaneRenderer;
import powercrystals.minefactoryreloaded.render.block.FactoryGlassRenderer;
import powercrystals.minefactoryreloaded.render.block.VineScaffoldRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntityNeedleRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntityPinkSlimeRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntityRocketRenderer;
import powercrystals.minefactoryreloaded.render.entity.EntitySafariNetRenderer;
import powercrystals.minefactoryreloaded.render.item.FactoryFluidOverlayRenderer;
import powercrystals.minefactoryreloaded.render.item.FactoryGlassPaneItemRenderer;
import powercrystals.minefactoryreloaded.render.item.NeedleGunItemRenderer;
import powercrystals.minefactoryreloaded.render.item.RocketItemRenderer;
import powercrystals.minefactoryreloaded.render.item.RocketLauncherItemRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.LaserDrillPrechargerRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.LaserDrillRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.RedNetCardItemRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.RedNetHistorianRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.RedNetLogicRenderer;
import powercrystals.minefactoryreloaded.render.tileentity.RedstoneCableRenderer;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrillPrecharger;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetHistorian;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

@SideOnly(value=Side.CLIENT)
public class MineFactoryReloadedClient
implements IScheduledTickHandler {
    public static MineFactoryReloadedClient instance;
    private static final int _lockonMax = 30;
    private static final int _lockonLostMax = 60;
    private int _lockonTicks = 0;
    private int _lockonLostTicks = 0;
    private Entity _lastEntityOver = null;
    public static HashMap<BlockPosition, Integer> prcPages;
    private static List<IHarvestAreaContainer> _areaTileEntities;

    public static void init() {
        instance = new MineFactoryReloadedClient();
        MineFactoryReloadedCore.renderIdConveyor = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdFactoryGlassPane = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdRedstoneCable = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdFluidClassic = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdRedNetLogic = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdVineScaffold = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdFactoryGlass = RenderingRegistry.getNextAvailableRenderId();
        MineFactoryReloadedCore.renderIdDetCord = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdConveyor, (ISimpleBlockRenderingHandler)new ConveyorRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdFactoryGlassPane, (ISimpleBlockRenderingHandler)new FactoryGlassPaneRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntitySafariNet.class, (Render)new EntitySafariNetRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdFluidClassic, (ISimpleBlockRenderingHandler)new RenderBlockFluidClassic(MineFactoryReloadedCore.renderIdFluidClassic));
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdVineScaffold, (ISimpleBlockRenderingHandler)new VineScaffoldRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdFactoryGlass, (ISimpleBlockRenderingHandler)new FactoryGlassRenderer());
        RenderingRegistry.registerBlockHandler((int)MineFactoryReloadedCore.renderIdDetCord, (ISimpleBlockRenderingHandler)new DetCordRenderer());
        MinecraftForgeClient.registerItemRenderer((int)MineFactoryReloadedCore.factoryGlassPaneBlock.field_71990_ca, (IItemRenderer)new FactoryGlassPaneItemRenderer());
        MinecraftForgeClient.registerItemRenderer((int)MineFactoryReloadedCore.plasticCupItem.field_77779_bT, (IItemRenderer)new FactoryFluidOverlayRenderer());
        if (MineFactoryReloadedCore.syringeEmptyItem instanceof IFluidContainerItem) {
            MinecraftForgeClient.registerItemRenderer((int)MineFactoryReloadedCore.syringeEmptyItem.field_77779_bT, (IItemRenderer)new FactoryFluidOverlayRenderer(false));
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityFishingRod.class, (Render)new RenderSnowball(MineFactoryReloadedCore.fishingRodItem));
        if (MFRConfig.vanillaOverrideGlassPane.getBoolean(true)) {
            MinecraftForgeClient.registerItemRenderer((int)Block.field_72003_bq.field_71990_ca, (IItemRenderer)new FactoryGlassPaneItemRenderer());
        }
        RedstoneCableRenderer redstoneCableRenderer = new RedstoneCableRenderer();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedNetCable.class, (TileEntitySpecialRenderer)redstoneCableRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)redstoneCableRenderer);
        RedNetLogicRenderer redNetLogicRenderer = new RedNetLogicRenderer();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedNetLogic.class, (TileEntitySpecialRenderer)redNetLogicRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)redNetLogicRenderer);
        RedNetHistorianRenderer redNetHistorianRenderer = new RedNetHistorianRenderer();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRedNetHistorian.class, (TileEntitySpecialRenderer)redNetHistorianRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)redNetHistorianRenderer);
        MinecraftForgeClient.registerItemRenderer((int)MineFactoryReloadedCore.logicCardItem.field_77779_bT, (IItemRenderer)new RedNetCardItemRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserDrill.class, (TileEntitySpecialRenderer)new LaserDrillRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserDrillPrecharger.class, (TileEntitySpecialRenderer)new LaserDrillPrechargerRenderer());
        MinecraftForgeClient.registerItemRenderer((int)MineFactoryReloadedCore.needlegunItem.field_77779_bT, (IItemRenderer)new NeedleGunItemRenderer());
        MinecraftForgeClient.registerItemRenderer((int)MineFactoryReloadedCore.rocketItem.field_77779_bT, (IItemRenderer)new RocketItemRenderer());
        MinecraftForgeClient.registerItemRenderer((int)MineFactoryReloadedCore.rocketLauncherItem.field_77779_bT, (IItemRenderer)new RocketLauncherItemRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityNeedle.class, (Render)new EntityNeedleRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityRocket.class, (Render)new EntityRocketRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityPinkSlime.class, (Render)new EntityPinkSlimeRenderer((ModelBase)new ModelSlime(16), (ModelBase)new ModelSlime(0), 0.25f));
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)instance, (Side)Side.CLIENT);
        TickRegistry.registerTickHandler((ITickHandler)new RenderTickHandler(), (Side)Side.CLIENT);
        VillagerRegistry.instance().registerVillagerSkin(MFRConfig.zoolologistEntityId.getInt(), new ResourceLocation("minefactoryreloaded:textures/villager/zoologist.png"));
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public void tickStart(EnumSet<TickType> enumSet, Object ... objectArray) {
        if (!(objectArray[0] instanceof EntityPlayerSP)) {
            return;
        }
        EntityPlayerSP entityPlayerSP = (EntityPlayerSP)objectArray[0];
        ItemStack itemStack = entityPlayerSP.field_71071_by.func_70448_g();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemRocketLauncher) {
            Entity entity = this.rayTrace();
            if (this._lastEntityOver != null && this._lastEntityOver.field_70128_L) {
                this._lastEntityOver = null;
                this._lockonTicks = 0;
            } else if ((entity == null || entity != this._lastEntityOver) && this._lockonLostTicks > 0) {
                --this._lockonLostTicks;
            } else if (entity == null && this._lockonLostTicks == 0) {
                if (this._lockonTicks > 0) {
                    --this._lockonTicks;
                }
                this._lastEntityOver = null;
            } else if (this._lastEntityOver == null) {
                this._lastEntityOver = entity;
            } else if (this._lockonTicks < 30) {
                ++this._lockonTicks;
                if (this._lockonTicks >= 30) {
                    this._lockonLostTicks = 60;
                }
            } else if (entity != null && entity == this._lastEntityOver) {
                this._lockonLostTicks = 60;
            }
        }
    }

    public void tickEnd(EnumSet<TickType> enumSet, Object ... objectArray) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "MineFactoryReloaded.client";
    }

    public int nextTickSpacing() {
        return 0;
    }

    @ForgeSubscribe
    public void setArmorModel(RenderPlayerEvent.SetArmorModel setArmorModel) {
        ItemStack itemStack = setArmorModel.stack;
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            int n = 3 - setArmorModel.slot;
            if (item == MineFactoryReloadedCore.plasticCupItem) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(item.getArmorTexture(itemStack, setArmorModel.entity, n, null)));
                ModelBiped modelBiped = new ModelBiped(1.0f);
                modelBiped.field_78116_c.field_78806_j = n == 0;
                modelBiped.field_78114_d.field_78806_j = n == 0;
                modelBiped.field_78115_e.field_78806_j = n == 1 || n == 2;
                modelBiped.field_78112_f.field_78806_j = n == 1;
                modelBiped.field_78113_g.field_78806_j = n == 1;
                modelBiped.field_78123_h.field_78806_j = n == 2 || n == 3;
                modelBiped.field_78124_i.field_78806_j = n == 2 || n == 3;
                setArmorModel.renderer.func_77042_a((ModelBase)modelBiped);
                modelBiped.field_78095_p = setArmorModel.entityLiving.func_70678_g(setArmorModel.partialRenderTick);
                modelBiped.field_78093_q = setArmorModel.entity.func_70115_ae();
                modelBiped.field_78091_s = setArmorModel.entityLiving.func_70631_g_();
                float f = 1.0f;
                GL11.glColor3f((float)f, (float)f, (float)f);
                if (itemStack.func_77948_v()) {
                    setArmorModel.result = 15;
                    return;
                }
                setArmorModel.result = 1;
            }
        }
    }

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void renderWorldLast(RenderWorldLastEvent renderWorldLastEvent) {
        EntityClientPlayerMP entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g;
        if (entityClientPlayerMP.field_71071_by.func_70448_g() == null || entityClientPlayerMP.field_71071_by.func_70448_g().field_77993_c != MineFactoryReloadedCore.factoryHammerItem.field_77779_bT) {
            return;
        }
        float f = -((float)(entityClientPlayerMP.field_70142_S + (entityClientPlayerMP.field_70165_t - entityClientPlayerMP.field_70142_S) * (double)renderWorldLastEvent.partialTicks));
        float f2 = -((float)(entityClientPlayerMP.field_70137_T + (entityClientPlayerMP.field_70163_u - entityClientPlayerMP.field_70137_T) * (double)renderWorldLastEvent.partialTicks));
        float f3 = -((float)(entityClientPlayerMP.field_70136_U + (entityClientPlayerMP.field_70161_v - entityClientPlayerMP.field_70136_U) * (double)renderWorldLastEvent.partialTicks));
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        for (IHarvestAreaContainer iHarvestAreaContainer : _areaTileEntities) {
            if (((TileEntity)iHarvestAreaContainer).func_70320_p()) continue;
            float f4 = (float)(iHarvestAreaContainer.getHAM().getOriginX() & 0xF) / 16.0f;
            float f5 = (float)(iHarvestAreaContainer.getHAM().getOriginY() & 0xF) / 16.0f;
            float f6 = (float)(iHarvestAreaContainer.getHAM().getOriginZ() & 0xF) / 16.0f;
            GL11.glPushMatrix();
            GL11.glColor4f((float)f4, (float)f5, (float)f6, (float)0.4f);
            GL11.glTranslatef((float)f, (float)f2, (float)f3);
            MineFactoryReloadedClient.renderAABB(iHarvestAreaContainer.getHAM().getHarvestArea().toAxisAlignedBB());
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void addTileToAreaList(IHarvestAreaContainer iHarvestAreaContainer) {
        _areaTileEntities.add(iHarvestAreaContainer);
    }

    public static void removeTileFromAreaList(IHarvestAreaContainer iHarvestAreaContainer) {
        _areaTileEntities.remove(iHarvestAreaContainer);
    }

    public int getLockedEntity() {
        if (this._lastEntityOver != null && this._lockonTicks >= 30) {
            return this._lastEntityOver.field_70157_k;
        }
        return Integer.MIN_VALUE;
    }

    public int getLockTimeRemaining() {
        if (this._lastEntityOver != null && this._lockonTicks >= 30) {
            return 60 - this._lockonLostTicks;
        }
        return (30 - this._lockonTicks) * 2;
    }

    private Entity rayTrace() {
        if (Minecraft.func_71410_x().field_71451_h == null || Minecraft.func_71410_x().field_71441_e == null) {
            return null;
        }
        double d = 64.0;
        Vec3 vec3 = Minecraft.func_71410_x().field_71451_h.func_70666_h(1.0f);
        Vec3 vec32 = Minecraft.func_71410_x().field_71451_h.func_70676_i(1.0f);
        Vec3 vec33 = vec3.func_72441_c(vec32.field_72450_a * d, vec32.field_72448_b * d, vec32.field_72449_c * d);
        List list = Minecraft.func_71410_x().field_71441_e.func_72839_b((Entity)Minecraft.func_71410_x().field_71451_h, Minecraft.func_71410_x().field_71451_h.field_70121_D.func_72321_a(vec32.field_72450_a * d, vec32.field_72448_b * d, vec32.field_72449_c * d).func_72314_b(1.0, 1.0, 1.0));
        double d2 = d;
        Entity entity = null;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity2 = (Entity)list.get(i);
            if (!entity2.func_70067_L()) continue;
            double d4 = entity2.func_70111_Y();
            AxisAlignedBB axisAlignedBB = entity2.field_70121_D.func_72314_b(d4, d4, d4);
            MovingObjectPosition movingObjectPosition = axisAlignedBB.func_72327_a(vec3, vec33);
            if (axisAlignedBB.func_72318_a(vec3)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                entity = entity2;
                d2 = 0.0;
                continue;
            }
            if (movingObjectPosition == null || !((d3 = vec3.func_72438_d(movingObjectPosition.field_72307_f)) < d2) && d2 != 0.0) continue;
            entity = entity2;
            d2 = d3;
        }
        if (entity != null) {
            return entity;
        }
        return null;
    }

    private static void renderAABB(AxisAlignedBB axisAlignedBB) {
        double d = 0.01;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72340_a + d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72339_c + d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72337_e - d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78377_a(axisAlignedBB.field_72336_d - d, axisAlignedBB.field_72338_b + d, axisAlignedBB.field_72334_f - d);
        tessellator.func_78381_a();
    }

    static {
        prcPages = new HashMap();
        _areaTileEntities = new LinkedList<IHarvestAreaContainer>();
    }
}

