/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.block.BlockFactoryRail;
import powercrystals.minefactoryreloaded.setup.MFRConfig;

public class BlockRailPassengerDropoff
extends BlockFactoryRail {
    public BlockRailPassengerDropoff(int n) {
        super(n, true);
        this.func_71864_b("mfr.rail.passenger.dropoff");
    }

    @Override
    public void onMinecartPass(World world, EntityMinecart entityMinecart, int n, int n2, int n3) {
        Class clazz;
        if (world.field_72995_K) {
            return;
        }
        Class clazz2 = clazz = this.isPowered(world, n, n2, n3) ? EntityLiving.class : EntityPlayer.class;
        if (!clazz.isInstance(entityMinecart.field_70153_n)) {
            return;
        }
        Entity entity = entityMinecart.field_70153_n;
        AxisAlignedBB axisAlignedBB = this.findSpaceForPlayer(entity, n, n2, n3, world);
        if (axisAlignedBB == null) {
            return;
        }
        entity.func_70078_a(null);
        MineFactoryReloadedCore.proxy.movePlayerToCoordinates((EntityLivingBase)entity, axisAlignedBB.field_72340_a + (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) / 2.0, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c + (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) / 2.0);
    }

    private AxisAlignedBB findSpaceForPlayer(Entity entity, int n, int n2, int n3, World world) {
        AxisAlignedBB axisAlignedBB = entity.field_70121_D.func_72325_c((Math.floor(entity.field_70165_t) - entity.field_70165_t) / 2.0, (Math.floor(entity.field_70163_u) - entity.field_70163_u) / 2.0, (Math.floor(entity.field_70161_v) - entity.field_70161_v) / 2.0);
        axisAlignedBB.func_72317_d((double)((int)axisAlignedBB.field_72340_a) - axisAlignedBB.field_72340_a, (double)((int)axisAlignedBB.field_72338_b) - axisAlignedBB.field_72338_b, (double)((int)axisAlignedBB.field_72339_c) - axisAlignedBB.field_72339_c);
        axisAlignedBB.func_72317_d((double)n - axisAlignedBB.field_72340_a, 0.0, (double)n3 - axisAlignedBB.field_72339_c);
        int n4 = MFRConfig.passengerRailSearchMaxHorizontal.getInt();
        int n5 = MFRConfig.passengerRailSearchMaxVertical.getInt();
        axisAlignedBB.func_72317_d(0.25, (double)(-n5) + 0.01, 0.25);
        for (int i = -n5; i <= n5; ++i) {
            axisAlignedBB.func_72317_d((double)(-n4), 0.0, 0.0);
            for (int j = -n4; j <= n4; ++j) {
                axisAlignedBB.func_72317_d(0.0, 0.0, (double)(-n4));
                for (int k = -n4; k <= n4; ++k) {
                    int n6 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72340_a + (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) / 2.0));
                    int n7 = MathHelper.func_76128_c((double)axisAlignedBB.field_72338_b);
                    int n8 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72339_c + (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) / 2.0));
                    if (world.func_72840_a(axisAlignedBB).isEmpty() && !this.isBadBlockToStandIn(world, n6, n7, n8) && !this.isBadBlockToStandOn(world, n6, n7 - 1, n8)) {
                        return axisAlignedBB;
                    }
                    axisAlignedBB.func_72317_d(0.0, 0.0, 1.0);
                }
                axisAlignedBB.func_72317_d(1.0, 0.0, (double)(-n4 - 1));
            }
            axisAlignedBB.func_72317_d((double)(-n4 - 1), 1.0, 0.0);
        }
        return null;
    }

    private boolean isBadBlockToStandOn(World world, int n, int n2, int n3) {
        Block block = Block.field_71973_m[world.func_72798_a(n, n2, n3)];
        return block == null || block.isAirBlock(world, n, n2, n3) || this.isBadBlockToStandIn(world, n, n2, n3) || !block.isBlockSolidOnSide(world, n, n2, n3, ForgeDirection.UP);
    }

    private boolean isBadBlockToStandIn(World world, int n, int n2, int n3) {
        Block block = Block.field_71973_m[world.func_72798_a(n, n2, n3)];
        return block != null && (block.field_72018_cp.func_76224_d() || block instanceof BlockRailBase);
    }
}

