/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.block.BlockFactoryMachine;
import powercrystals.minefactoryreloaded.block.ItemBlockFactory;
import powercrystals.minefactoryreloaded.setup.Machine;

public class ItemBlockFactoryMachine
extends ItemBlockFactory
implements IEnergyContainerItem {
    private int _machineBlockIndex;

    public ItemBlockFactoryMachine(int n) {
        super(n);
        int n2;
        this.func_77656_e(0);
        this.func_77627_a(true);
        this._machineBlockIndex = ((BlockFactoryMachine)Block.field_71973_m[this.func_77883_f()]).getBlockIndex();
        int n3 = Machine.getHighestMetadata(this._machineBlockIndex);
        String[] stringArray = new String[n3 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            stringArray[n2] = Machine.getMachineFromIndex(this._machineBlockIndex, n2).getInternalName();
        }
        this.setNames(stringArray);
        for (n2 = 0; n2 <= n3; ++n2) {
            ItemStack itemStack = new ItemStack((Item)this, 1, n2);
            GameRegistry.registerCustomItemStack((String)itemStack.func_77977_a(), (ItemStack)itemStack);
        }
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        return this._names[Math.min(itemStack.func_77960_j(), this._names.length - 1)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        this.getMachine(itemStack).addInformation(itemStack, entityPlayer, list, bl);
    }

    private Machine getMachine(ItemStack itemStack) {
        return Machine.getMachineFromIndex(this._machineBlockIndex, itemStack.func_77960_j());
    }

    private int getTransferRate(ItemStack itemStack) {
        return this.getMachine(itemStack).getActivationEnergy();
    }

    private void setEnergy(ItemStack itemStack, int n) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
            itemStack.func_77982_d(nBTTagCompound);
        }
        nBTTagCompound.func_74768_a("energyStored", n);
    }

    @Override
    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        n = Math.min(this.getTransferRate(itemStack), n);
        if (n <= 0) {
            return 0;
        }
        int n5 = this.getEnergyStored(itemStack);
        if (!bl & (n4 = (n3 = Math.max(0, Math.min(n2 = this.getMaxEnergyStored(itemStack), n5 + n))) - n5) > 0) {
            this.setEnergy(itemStack, n3);
        }
        return n4;
    }

    @Override
    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        n = Math.min(this.getTransferRate(itemStack), n);
        if (n <= 0) {
            return 0;
        }
        if (!bl & (n4 = (n3 = this.getEnergyStored(itemStack)) - (n2 = Math.max(0, n3 - n))) > 0) {
            this.setEnergy(itemStack, n2);
        }
        return n4;
    }

    @Override
    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74762_e("energyStored");
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.getMachine(itemStack).getMaxEnergyStorage();
    }
}

