/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.core.BlockPool;
import powercrystals.minefactoryreloaded.core.HarvestMode;
import powercrystals.minefactoryreloaded.core.IHarvestManager;

public class TreeHarvestManager
implements IHarvestManager {
    private static ForgeDirection[] SIDES = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH};
    private BlockPool _treeBlocks;
    private boolean _isDone;
    private HarvestMode _harvestMode;
    private Area _treeArea;
    private World _world;

    public TreeHarvestManager(World world, Area area, HarvestMode harvestMode) {
        this.reset(world, area, harvestMode);
    }

    @Override
    public BlockPosition getNextBlock() {
        BlockPool.BlockNode blockNode = this._treeBlocks.poke();
        return blockNode.bp;
    }

    @Override
    public void moveNext() {
        this.searchForTreeBlocks(this._treeBlocks.shift());
        if (this._treeBlocks.size() == 0L) {
            this._isDone = true;
        }
    }

    private void searchForTreeBlocks(BlockPool.BlockNode blockNode) {
        BlockPosition blockPosition = blockNode.bp;
        Map<Integer, IFactoryHarvestable> map = MFRRegistry.getHarvestables();
        BlockPool.BlockNode blockNode2 = this._harvestMode.isInverted ? BlockPool.getNext(blockPosition.x, blockPosition.y - 1, blockPosition.z) : BlockPool.getNext(blockPosition.x, blockPosition.y + 1, blockPosition.z);
        if (this.isValid(blockNode2.bp, map)) {
            this._treeBlocks.push(blockNode2);
        } else {
            blockNode2.free();
        }
        for (ForgeDirection forgeDirection : SIDES) {
            blockNode2 = BlockPool.getNext(blockPosition.x + forgeDirection.offsetX, blockPosition.y + forgeDirection.offsetY, blockPosition.z + forgeDirection.offsetZ);
            if (this.isValid(blockNode2.bp, map)) {
                this._treeBlocks.push(blockNode2);
                continue;
            }
            blockNode2.free();
        }
        blockNode2 = this._harvestMode.isInverted ? BlockPool.getNext(blockPosition.x, blockPosition.y + 1, blockPosition.z) : BlockPool.getNext(blockPosition.x, blockPosition.y - 1, blockPosition.z);
        if (this.isValid(blockNode2.bp, map)) {
            this._treeBlocks.push(blockNode2);
        } else {
            blockNode2.free();
        }
        blockNode.free();
    }

    private boolean isValid(BlockPosition blockPosition, Map<Integer, IFactoryHarvestable> map) {
        if (blockPosition.x > this._treeArea.xMax | blockPosition.x < this._treeArea.xMin | blockPosition.z > this._treeArea.zMax | blockPosition.z < this._treeArea.zMin | blockPosition.y > this._treeArea.yMax | blockPosition.y < this._treeArea.yMin || !this._world.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z)) {
            return false;
        }
        Integer n = this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (map.containsKey(n)) {
            HarvestType harvestType = map.get(n).getHarvestType();
            return harvestType == HarvestType.TreeFlipped | harvestType == HarvestType.TreeLeaf | harvestType == HarvestType.Tree;
        }
        return false;
    }

    @Override
    public void reset(World world, Area area, HarvestMode harvestMode) {
        this._world = world;
        this._harvestMode = harvestMode;
        this._treeArea = area;
        this._isDone = false;
        this._treeBlocks = new BlockPool();
        BlockPosition blockPosition = area.getOrigin();
        this._treeBlocks.push(BlockPool.getNext(blockPosition.x, blockPosition.y, blockPosition.z));
    }

    @Override
    public boolean getIsDone() {
        return this._isDone;
    }

    @Override
    public BlockPosition getOrigin() {
        return this._treeArea.getOrigin();
    }
}

