/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.ILiquidDrinkHandler;
import powercrystals.minefactoryreloaded.item.ItemSyringe;

public class ItemSyringeLiquid
extends ItemSyringe
implements IFluidContainerItem {
    private boolean _prefix = false;
    @SideOnly(value=Side.CLIENT)
    protected Icon fillIcon;

    public ItemSyringeLiquid(int n) {
        super(n);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a());
        this.fillIcon = iconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".fill");
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.getFluid(itemStack) != null) {
            return this.func_77658_a() + (this._prefix ? ".prefix" : ".suffix");
        }
        return this.func_77658_a();
    }

    public String getLocalizedName(String string) {
        String string2 = this.func_77658_a() + "." + string;
        if (StatCollector.func_94522_b((String)string2)) {
            return StatCollector.func_74838_a((String)string2);
        }
        return null;
    }

    public String func_77628_j(ItemStack itemStack) {
        String string = this.getFluidName(itemStack);
        String string2 = this.getLocalizedName(string);
        if (string2 != null && !string2.isEmpty()) {
            return EnumChatFormatting.RESET + string2 + EnumChatFormatting.RESET;
        }
        if (string == null) {
            return super.func_77628_j(itemStack);
        }
        Fluid fluid = FluidRegistry.getFluid((String)string);
        if (fluid != null) {
            string = fluid.getLocalizedName();
        }
        this._prefix = true;
        string2 = super.func_77628_j(itemStack);
        this._prefix = false;
        string2 = string2 != null ? string2.trim() : "";
        string = (string2.isEmpty() ? "" : string2 + " ") + string;
        string2 = super.func_77628_j(itemStack);
        string2 = string2 != null ? string2.trim() : "";
        string = string + (string2.isEmpty() ? " Syringe" : " " + string2);
        return string;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack itemStack, int n) {
        switch (n) {
            case 1: {
                return this.fillIcon;
            }
        }
        return this.field_77791_bV;
    }

    public String getFluidName(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        return nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluidName") ? null : nBTTagCompound.func_74779_i("fluidName");
    }

    @Override
    public boolean canInject(World world, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        FluidStack fluidStack = this.getFluid(itemStack);
        return fluidStack != null && fluidStack.amount >= this.getCapacity(itemStack) && entityLivingBase instanceof EntityPlayer;
    }

    @Override
    public boolean inject(World world, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        ILiquidDrinkHandler iLiquidDrinkHandler = MFRRegistry.getLiquidDrinkHandlers().get(this.getFluidName(itemStack));
        if (iLiquidDrinkHandler != null) {
            iLiquidDrinkHandler.onDrink((EntityPlayer)entityLivingBase);
            this.drain(itemStack, Integer.MAX_VALUE, true);
            return true;
        }
        return false;
    }

    public FluidStack getFluid(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        return nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("fluid"));
    }

    public int getCapacity(ItemStack itemStack) {
        return 1000;
    }

    public int fill(ItemStack itemStack, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.getCapacity(itemStack);
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = null;
        FluidStack fluidStack2 = null;
        if (nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") || (nBTTagCompound2 = nBTTagCompound.func_74775_l("fluid")) == null || (fluidStack2 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null) {
            n = Math.min(n2, fluidStack.amount);
        }
        if (fluidStack2 == null) {
            if (bl) {
                fluidStack2 = fluidStack.copy();
            }
        } else {
            if (!fluidStack2.isFluidEqual(fluidStack)) {
                return 0;
            }
            n = Math.min(n2 - fluidStack2.amount, fluidStack.amount);
        }
        n = Math.max(n, 0);
        if (bl) {
            if (nBTTagCompound == null) {
                nBTTagCompound = itemStack.field_77990_d = new NBTTagCompound();
            }
            fluidStack2.amount = n;
            nBTTagCompound.func_74782_a("fluid", (NBTBase)fluidStack2.writeToNBT(nBTTagCompound2 == null ? new NBTTagCompound() : nBTTagCompound2));
            nBTTagCompound.func_74772_a("uniqifier", (long)(System.identityHashCode(fluidStack) << 32 | System.identityHashCode(itemStack)));
            nBTTagCompound.func_74778_a("fluidName", fluidStack2.getFluid().getName());
        }
        return n;
    }

    public FluidStack drain(ItemStack itemStack, int n, boolean bl) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = null;
        FluidStack fluidStack = null;
        if (nBTTagCompound == null || !nBTTagCompound.func_74764_b("fluid") || (nBTTagCompound2 = nBTTagCompound.func_74775_l("fluid")) == null || (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound2)) == null) {
            return null;
        }
        int n2 = Math.min(n, fluidStack.amount);
        if (bl) {
            nBTTagCompound.func_82580_o("fluid");
            nBTTagCompound.func_82580_o("uniqifier");
            nBTTagCompound.func_82580_o("fluidName");
            if (nBTTagCompound.func_82582_d()) {
                itemStack.func_77982_d(null);
            }
        }
        fluidStack.amount = n2;
        return fluidStack;
    }
}

