/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public abstract class TileEntityGenerator
extends TileEntityFactoryInventory
implements IPowerEmitter,
IEnergyHandler {
    private IEnergyHandler[] energyHandlerCache;
    private IPowerReceptor[] powerReceptorCache;
    private boolean deadCache;

    protected TileEntityGenerator(Machine machine) {
        super(machine);
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        this.deadCache = true;
        this.energyHandlerCache = new IEnergyHandler[6];
        this.powerReceptorCache = new IPowerReceptor[6];
    }

    @Override
    public void func_70316_g() {
        if (this.deadCache) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                this.onNeighborTileChange(this.field_70329_l + forgeDirection.offsetX, this.field_70330_m + forgeDirection.offsetY, this.field_70327_n + forgeDirection.offsetZ);
            }
            this.deadCache = false;
        }
        super.func_70316_g();
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        TileEntity tileEntity = this.field_70331_k.func_72796_p(n, n2, n3);
        if (n < this.field_70329_l) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_70329_l) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_70327_n) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_70327_n) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_70330_m) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_70330_m) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity, int n) {
        if (tileEntity instanceof IEnergyHandler) {
            this.energyHandlerCache[n] = (IEnergyHandler)tileEntity;
        } else if (tileEntity instanceof IPowerReceptor) {
            this.powerReceptorCache[n] = (IPowerReceptor)tileEntity;
        } else {
            this.energyHandlerCache[n] = null;
            this.powerReceptorCache[n] = null;
        }
    }

    protected final int producePower(int n) {
        float f;
        int n2 = this.energyHandlerCache.length;
        while (n2-- > 0) {
            ForgeDirection forgeDirection;
            IEnergyHandler iEnergyHandler = this.energyHandlerCache[n2];
            if (iEnergyHandler == null || !iEnergyHandler.canInterface(forgeDirection = ForgeDirection.VALID_DIRECTIONS[n2])) continue;
            if (iEnergyHandler.receiveEnergy(forgeDirection, n, true) > 0) {
                n -= iEnergyHandler.receiveEnergy(forgeDirection, n, false);
            }
            if (n > 0) continue;
            return 0;
        }
        float f2 = f = (float)n / 10.0f;
        int n3 = this.powerReceptorCache.length;
        while (n3-- > 0) {
            float f3;
            ForgeDirection forgeDirection;
            PowerHandler.PowerReceiver powerReceiver;
            IPowerReceptor iPowerReceptor = this.powerReceptorCache[n3];
            if (iPowerReceptor == null || (powerReceiver = iPowerReceptor.getPowerReceiver(forgeDirection = ForgeDirection.VALID_DIRECTIONS[n3])) == null) continue;
            float f4 = powerReceiver.getMaxEnergyReceived();
            if (!(Math.min(f3, powerReceiver.getMaxEnergyStored() - powerReceiver.getEnergyStored()) > 0.0f)) continue;
            float f5 = Math.min(Math.min(f4, f2), powerReceiver.getMaxEnergyStored() - powerReceiver.getEnergyStored());
            powerReceiver.receiveEnergy(PowerHandler.Type.GATE, f5, forgeDirection);
            if (!((f2 -= f5) <= 0.0f)) continue;
            return 0;
        }
        n = (int)((float)n - (f - f2));
        return n;
    }

    @Override
    public int receiveEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return super.overridePipeConnection(pipeType, forgeDirection);
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection forgeDirection) {
        return true;
    }
}

