/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public abstract class TileEntityLiquidFabricator
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private int _liquidId;
    private int _liquidFabPerTick;

    protected TileEntityLiquidFabricator(int n, int n2, Machine machine) {
        super(machine, machine.getActivationEnergy() * n2);
        this._liquidId = n;
        this._liquidFabPerTick = n2;
    }

    @Override
    protected boolean activateMachine() {
        if (this._liquidId < 0) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        FluidStack fluidStack = new FluidStack(this._liquidId, this._liquidFabPerTick);
        if (this.fill(ForgeDirection.UNKNOWN, fluidStack, false) != this._liquidFabPerTick) {
            return false;
        }
        this.fill(ForgeDirection.UNKNOWN, fluidStack, true);
        return true;
    }

    @Override
    public int getWorkMax() {
        return 0;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(1000)};
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (fluidTank.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    @Override
    public boolean allowBucketDrain() {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

