/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLiquidGenerator;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerLiquidGenerator;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityGenerator;

public abstract class TileEntityLiquidGenerator
extends TileEntityGenerator
implements ITankContainerBucketable {
    private int _liquidConsumedPerTick;
    private int _powerProducedPerConsumption;
    private int _ticksBetweenConsumption;
    private int _outputPulseSize;
    private int _ticksSinceLastConsumption = 0;
    private int _bufferMax;
    private int _buffer;

    public TileEntityLiquidGenerator(Machine machine, int n, int n2) {
        this(machine, n, machine.getActivationEnergy() * n2, n2);
    }

    public TileEntityLiquidGenerator(Machine machine, int n, int n2, int n3) {
        super(machine);
        assert (machine.getActivationEnergy() != 0) : "Generators cannot produce 0 energy.";
        this._liquidConsumedPerTick = n;
        this._powerProducedPerConsumption = n2;
        this._ticksBetweenConsumption = n3;
        this._outputPulseSize = machine.getActivationEnergy();
        this._bufferMax = machine.getMaxEnergyStorage();
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(4000)};
    }

    protected abstract boolean isFluidFuel(FluidStack var1);

    protected String getFluidName(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        String string = fluidStack.getFluid().getName();
        if (string == null) {
            return null;
        }
        return string.trim().toLowerCase();
    }

    public int getBuffer() {
        return this._buffer;
    }

    public void setBuffer(int n) {
        this._buffer = n;
    }

    public int getBufferMax() {
        return this._bufferMax;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            boolean bl;
            this.setIsActive(this._buffer > this._outputPulseSize * 2);
            boolean bl2 = bl = ++this._ticksSinceLastConsumption < this._ticksBetweenConsumption;
            if (Util.isRedstonePowered((TileEntity)this)) {
                return;
            }
            int n = Math.min(this._buffer, this._outputPulseSize);
            this._buffer -= n;
            this._buffer += this.producePower(n);
            if (this._bufferMax - this._buffer < this._powerProducedPerConsumption | bl) {
                return;
            }
            FluidStack fluidStack = this.drain(ForgeDirection.UNKNOWN, this._liquidConsumedPerTick, false);
            if (fluidStack == null || fluidStack.amount != this._liquidConsumedPerTick) {
                return;
            }
            this._ticksSinceLastConsumption = 0;
            this.drain(ForgeDirection.UNKNOWN, this._liquidConsumedPerTick, true);
            this._buffer += this._powerProducedPerConsumption;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLiquidGenerator((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerLiquidGenerator getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLiquidGenerator(this, inventoryPlayer);
    }

    @Override
    public String getGuiBackground() {
        return "biofuelgenerator.png";
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (fluidTank.getFluidAmount() != 0 && !fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
            if (fluidTank.getFluidAmount() <= 0) continue;
            return fluidTank.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTank fluidTank : (FluidTank[])this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTank.getFluid())) continue;
                return fluidTank.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    @Override
    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("ticksSinceLastConsumption", this._ticksSinceLastConsumption);
        nBTTagCompound.func_74768_a("buffer", this._buffer);
    }

    @Override
    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this._ticksSinceLastConsumption = nBTTagCompound.func_74762_e("ticksSinceLastConsumption");
        this._buffer = nBTTagCompound.func_74762_e("buffer");
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

