/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.IFactoryLaserTarget;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;

public class TileEntityLaserDrillPrecharger
extends TileEntityFactoryPowered {
    private int stripTick = 0;

    public TileEntityLaserDrillPrecharger() {
        super(Machine.LaserDrillPrecharger);
        this.setCanRotate(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    protected boolean activateMachine() {
        IFactoryLaserTarget iFactoryLaserTarget = this.getDrill();
        if (iFactoryLaserTarget == null) {
            this.setIdleTicks(this.getIdleTicksMax());
            this.resetLaser();
        } else {
            int n = this.getActivationEnergy();
            ForgeDirection forgeDirection = this.getDirectionFacing().getOpposite();
            if (iFactoryLaserTarget.canFormBeamWith(forgeDirection)) {
                this.stripBlock();
                int n2 = iFactoryLaserTarget.addEnergy(forgeDirection, n, true);
                if (n2 == 0) {
                    iFactoryLaserTarget.addEnergy(forgeDirection, n, false);
                    return true;
                }
                n2 = iFactoryLaserTarget.addEnergy(forgeDirection, n, false);
                this.drainEnergy(n - n2);
            } else if (this.stripTick > 0) {
                --this.stripTick;
            } else {
                this.resetLaser();
                this.stripTick = 20;
            }
        }
        return false;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    public boolean shouldDrawBeam() {
        IFactoryLaserTarget iFactoryLaserTarget = this.getDrill();
        return iFactoryLaserTarget != null && iFactoryLaserTarget.canFormBeamWith(this.getDirectionFacing().getOpposite());
    }

    protected IFactoryLaserTarget getDrill() {
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        blockPosition.orientation = this.getDirectionFacing();
        blockPosition.moveForwards(1);
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!TileEntityLaserDrill.canReplaceBlock(Block.field_71973_m[n], this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z)) {
            return null;
        }
        blockPosition.moveForwards(1);
        TileEntity tileEntity = this.field_70331_k.func_72796_p(blockPosition.x, blockPosition.y, blockPosition.z);
        if (tileEntity instanceof IFactoryLaserTarget) {
            return (IFactoryLaserTarget)tileEntity;
        }
        return null;
    }

    protected void stripBlock() {
        if (this.stripTick > 0) {
            --this.stripTick;
            return;
        }
        this.stripTick = 20;
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        blockPosition.orientation = this.getDirectionFacing();
        blockPosition.moveForwards(1);
        if (this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z) != MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca) {
            this.field_70331_k.func_72832_d(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca, 1, 3);
        }
    }

    @Override
    public void onDisassembled() {
        super.onDisassembled();
        this.resetLaser();
    }

    protected void resetLaser() {
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        blockPosition.orientation = this.getDirectionFacing();
        blockPosition.moveForwards(1);
        if (this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z) == MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca) {
            this.field_70331_k.func_72921_c(blockPosition.x, blockPosition.y, blockPosition.z, 0, 0);
            this.field_70331_k.func_72836_a(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.fakeLaserBlock.field_71990_ca, 1);
        }
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_82115_m() {
        return 65536.0;
    }
}

