/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RoutedPayload;
import mrtjp.projectred.transportation.RoutingChipset;
import mrtjp.projectred.transportation.SyncResponse;
import org.lwjgl.input.Keyboard;

public class RoutingChipset_ItemOverflowResponder
extends RoutingChipset {
    private final RoutedPayload.SendPriority priority = this.getSendPriority();
    public int preference = 0;

    protected RoutedPayload.SendPriority getSendPriority() {
        return RoutedPayload.SendPriority.DEFAULT;
    }

    public void prefUp() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference += 10) : ++this.preference;
        if (this.preference > this.prefScale()) {
            this.preference = this.prefScale();
        }
    }

    public void prefDown() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference -= 10) : --this.preference;
        if (this.preference < -this.prefScale()) {
            this.preference = -this.prefScale();
        }
    }

    private int prefScale() {
        return 2 + this.getUpgradeBus().LLatency();
    }

    @Override
    public SyncResponse getSyncResponse(ItemKey item, SyncResponse rival) {
        InventoryWrapper inv;
        int room;
        mo real = this.inventoryProvider().getInventory();
        int side = this.inventoryProvider().getInterfacedSide();
        if (real == null || side < 0) {
            return null;
        }
        if ((this.priority.ordinal() > rival.priority.ordinal() || this.priority.ordinal() == rival.priority.ordinal() && this.preference > rival.customPriority) && (room = (inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side)).getRoomAvailableForItem(item)) > 0) {
            return new SyncResponse().setPriority(this.priority).setCustomPriority(this.preference).setItemCount(room);
        }
        return null;
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("pref", this.preference);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.preference = tag.e("pref");
    }

    @Override
    public List<String> infoCollection() {
        LinkedList<String> list = new LinkedList<String>();
        this.addPriorityInfo(list);
        return list;
    }

    @Override
    public ItemRoutingChip.EnumRoutingChip getChipType() {
        return ItemRoutingChip.EnumRoutingChip.ITEMOVERFLOWRESPONDER;
    }

    public void addPriorityInfo(List<String> list) {
        list.add(a.h + "Preference: " + this.preference);
    }

    @Override
    public RoutingChipset.UpgradeBus createUpgradeBus() {
        RoutingChipset.UpgradeBus b = new RoutingChipset.UpgradeBus(3, 0);
        b.setLatency(3, 5, 54, 0, 0, 0);
        b.Linfo = "raise maximum preference value";
        b.Lformula = "preference value = 2 + Latency";
        return b;
    }
}

