/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.world;

import cpw.mods.fml.common.registry.GameRegistry;
import enhancedcore.world.BlockPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;

public class Teleportation {
    protected WorldServer entryWorld;
    protected WorldServer exitWorld;
    protected BlockPosition entryLocation;
    protected BlockPosition exitLocation;
    protected ForgeDirection entryDirection;
    protected ForgeDirection exitDirection;
    protected Entity theEntity;
    protected boolean dimensionalTeleport;
    protected boolean allowTeleportation;
    private static final int PLAYER_TRAVEL_DELAY = 10;

    public static boolean canEntityTravel(Entity entity) {
        return entity != null && entity.field_71088_bW == 0;
    }

    public static void setCanEntityTravel(Entity entity, boolean state) {
        entity.field_71088_bW = state ? 0 : (entity instanceof EntityMinecart || entity instanceof EntityBoat ? 10 : entity.func_82147_ab());
    }

    public Teleportation(BlockPosition entry, BlockPosition exit, Entity entity, WorldServer entryW, WorldServer exitW) {
        this.entryLocation = entry;
        this.exitLocation = exit;
        this.entryWorld = entryW;
        this.exitWorld = exitW;
        this.theEntity = entity;
        this.dimensionalTeleport = this.entryWorld.field_73011_w.field_76574_g != this.exitWorld.field_73011_w.field_76574_g;
        this.allowTeleportation = true;
        int orientation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (orientation == 0) {
            this.entryDirection = ForgeDirection.SOUTH;
        } else if (orientation == 1) {
            this.entryDirection = ForgeDirection.WEST;
        } else if (orientation == 2) {
            this.entryDirection = ForgeDirection.NORTH;
        } else if (orientation == 3) {
            this.entryDirection = ForgeDirection.EAST;
        }
        this.exitDirection = this.entryDirection;
    }

    private Entity doTeleport() {
        if (!(this.isValidEntity() && this.isValidEntry() && this.isValidExit() && !this.theEntity.field_70170_p.field_72995_K && this.allowTeleportation && Teleportation.canEntityTravel(this.theEntity))) {
            return this.theEntity;
        }
        Entity ridingEntity = null;
        EntityPlayerMP player = null;
        this.exitWorld.field_73059_b.func_73158_c(this.exitLocation.getX() >> 4, this.exitLocation.getZ() >> 4);
        if (this.theEntity.field_70154_o != null) {
            ridingEntity = this.handleRidingEntity();
            this.theEntity.func_70078_a(null);
        }
        this.entryWorld.func_72866_a(this.theEntity, false);
        if (this.theEntity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)this.theEntity;
            player.func_71053_j();
            if (this.dimensionalTeleport) {
                player.field_71093_bK = this.exitWorld.field_73011_w.field_76574_g;
                player.field_71135_a.func_72567_b((Packet)new Packet9Respawn(player.field_71093_bK, (byte)this.exitWorld.field_73013_u, this.exitWorld.func_72912_H().func_76067_t(), this.exitWorld.func_72800_K(), player.field_71134_c.func_73081_b()));
                this.entryWorld.func_73040_p().func_72695_c(player);
            }
        }
        if (this.dimensionalTeleport) {
            if (this.theEntity instanceof EntityPlayer) {
                EntityPlayer play = (EntityPlayer)this.theEntity;
                play.func_71053_j();
                this.entryWorld.field_73010_i.remove(play);
                this.entryWorld.func_72854_c();
                int cX = play.field_70176_ah;
                int cZ = play.field_70164_aj;
                if (play.field_70175_ag && this.entryWorld.func_72863_F().func_73149_a(cX, cZ)) {
                    this.entryWorld.func_72964_e(cX, cZ).func_76622_b((Entity)play);
                    this.entryWorld.func_72964_e((int)cX, (int)cZ).field_76643_l = true;
                }
                this.entryWorld.field_72996_f.remove(play);
            }
            this.theEntity.field_70128_L = false;
            this.onExitDimension(this.entryWorld.field_73011_w.field_76574_g);
        }
        this.theEntity.func_70012_b((double)this.exitLocation.getZ() + 0.5, (double)this.exitLocation.getY() + 0.5, (double)this.exitLocation.getZ() + 0.5, this.theEntity.field_70177_z, this.theEntity.field_70125_A);
        this.handleEntityMomentum();
        this.handleEntityRotation();
        if (this.dimensionalTeleport) {
            if (!(this.theEntity instanceof EntityPlayer)) {
                NBTTagCompound tag = new NBTTagCompound();
                this.theEntity.field_70128_L = false;
                this.theEntity.field_70153_n = null;
                this.theEntity.func_70039_c(tag);
                this.theEntity.field_70128_L = true;
                this.theEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)this.exitWorld);
                if (this.theEntity == null) {
                    return null;
                }
            }
            this.exitWorld.func_72838_d(this.theEntity);
            this.theEntity.func_70029_a((World)this.exitWorld);
            this.onEnterDimension(this.exitWorld.field_73011_w.field_76574_g);
        }
        if (this.theEntity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)this.theEntity;
            if (this.dimensionalTeleport) {
                player.field_71133_b.func_71203_ab().func_72375_a(player, this.exitWorld);
            }
            player.field_71135_a.func_72569_a((double)this.exitLocation.getX() + 0.5, (double)this.exitLocation.getY() + 0.5, (double)this.exitLocation.getZ() + 0.5, player.field_70177_z, player.field_70125_A);
        }
        this.exitWorld.func_72866_a(this.theEntity, false);
        if (this.theEntity instanceof EntityPlayerMP && this.dimensionalTeleport) {
            player = (EntityPlayerMP)this.theEntity;
            player.field_71134_c.func_73080_a(this.exitWorld);
            player.field_71133_b.func_71203_ab().func_72354_b(player, this.exitWorld);
            player.field_71133_b.func_71203_ab().func_72385_f(player);
            for (PotionEffect effect : player.func_70651_bq()) {
                player.field_71135_a.func_72567_b((Packet)new Packet41EntityEffect(player.field_70157_k, effect));
            }
            player.field_71135_a.func_72567_b((Packet)new Packet43Experience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            GameRegistry.onPlayerChangedDimension((EntityPlayer)player);
        }
        if (ridingEntity != null) {
            this.theEntity.func_70078_a(ridingEntity);
        }
        Teleportation.setCanEntityTravel(this.theEntity, false);
        return this.theEntity;
    }

    protected void handleEntityMomentum() {
    }

    protected void handleEntityRotation() {
    }

    public Entity handleRidingEntity() {
        return new Teleportation(this.entryLocation, this.exitLocation, this.theEntity.field_70154_o, this.entryWorld, this.exitWorld).doTeleport();
    }

    protected boolean isValidEntity() {
        return true;
    }

    protected boolean isValidEntry() {
        return true;
    }

    protected boolean isValidExit() {
        return this.exitWorld.func_72799_c(this.exitLocation.getX(), this.exitLocation.getY(), this.exitLocation.getZ()) && this.exitWorld.func_72799_c(this.exitLocation.getX(), this.exitLocation.getY() + 1, this.exitLocation.getZ());
    }

    protected void onEnterDimension(int dimID) {
    }

    protected void onExitDimension(int dimID) {
    }
}

