/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.vector;

import net.minecraftforge.common.ForgeDirection;
import universalelectricity.api.vector.IRotation;
import universalelectricity.api.vector.IVector3;

public class EulerAngle
implements IRotation,
IVector3 {
    public double yaw;
    public double pitch;
    public double roll;

    public EulerAngle() {
        this(0.0, 0.0, 0.0);
    }

    public EulerAngle(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                this.pitch = -90.0;
                break;
            }
            case UP: {
                this.pitch = 90.0;
                break;
            }
            case NORTH: {
                this.yaw = 0.0;
                break;
            }
            case SOUTH: {
                this.yaw = 180.0;
                break;
            }
            case WEST: {
                this.yaw = 90.0;
                break;
            }
            case EAST: {
                this.yaw = -90.0;
                break;
            }
        }
    }

    public EulerAngle(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public EulerAngle(double[] angles) {
        this(angles[0], angles[1], angles[2]);
    }

    public EulerAngle(EulerAngle angle) {
        this(angle.yaw(), angle.pitch(), angle.roll());
    }

    public EulerAngle(double yaw, double pitch) {
        this(yaw, pitch, 0.0);
    }

    @Override
    public double yaw() {
        return this.yaw;
    }

    @Override
    public double pitch() {
        return this.pitch;
    }

    @Override
    public double roll() {
        return this.roll;
    }

    public double yawRadians() {
        return Math.toRadians(this.yaw());
    }

    public double pitchRadians() {
        return Math.toRadians(this.pitch());
    }

    public double rollRadians() {
        return Math.toRadians(this.roll());
    }

    @Override
    public double x() {
        return -Math.sin(this.yawRadians()) * Math.cos(this.pitchRadians());
    }

    @Override
    public double y() {
        return Math.sin(this.pitchRadians());
    }

    @Override
    public double z() {
        return -Math.cos(this.yawRadians()) * Math.cos(this.pitchRadians());
    }

    public double[] toArray() {
        return new double[]{this.yaw(), this.pitch(), this.roll()};
    }

    public double[] toRadianArray() {
        return new double[]{this.yawRadians(), this.pitchRadians(), this.rollRadians()};
    }

    public EulerAngle set(int i, double value) {
        switch (i) {
            case 0: {
                this.yaw = value;
                break;
            }
            case 1: {
                this.pitch = value;
                break;
            }
            case 2: {
                this.roll = value;
            }
        }
        return this;
    }

    public EulerAngle difference(EulerAngle other) {
        return new EulerAngle(this.yaw() - other.yaw(), this.pitch() - other.pitch(), this.roll() - other.roll());
    }

    public EulerAngle absoluteDifference(EulerAngle other) {
        return new EulerAngle(EulerAngle.getAngleDifference(this.yaw(), other.yaw()), EulerAngle.getAngleDifference(this.pitch(), other.pitch()), EulerAngle.getAngleDifference(this.roll(), other.roll()));
    }

    public boolean isWithin(EulerAngle other, double margin) {
        for (int i = 0; i < 3; ++i) {
            if (!(this.absoluteDifference(other).toArray()[i] > margin)) continue;
            return false;
        }
        return true;
    }

    public static double getAngleDifference(double angleA, double angleB) {
        return Math.abs(angleA - angleB);
    }

    public EulerAngle clone() {
        return new EulerAngle(this.yaw(), this.pitch(), this.roll());
    }

    public static double clampAngleTo360(double var) {
        return EulerAngle.clampAngle(var, -360.0, 360.0);
    }

    public static double clampAngleTo180(double var) {
        return EulerAngle.clampAngle(var, -180.0, 180.0);
    }

    public static double clampAngle(double var, double min, double max) {
        while (var < min) {
            var += 360.0;
        }
        while (var > max) {
            var -= 360.0;
        }
        return var;
    }

    public int hashCode() {
        long x = Double.doubleToLongBits(this.yaw());
        long y = Double.doubleToLongBits(this.pitch());
        long z = Double.doubleToLongBits(this.roll());
        int hash = (int)(x ^ x >>> 32);
        hash = 31 * hash + (int)(y ^ y >>> 32);
        hash = 31 * hash + (int)(z ^ z >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof EulerAngle) {
            EulerAngle angle = (EulerAngle)o;
            return this.yaw() == angle.yaw() && this.pitch() == angle.pitch() && this.roll() == angle.roll();
        }
        return false;
    }

    public String toString() {
        return "Angle [" + this.yaw() + "," + this.pitch() + "," + this.roll() + "]";
    }
}

