/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.CompatibilityType;

public class ModuleIndustrialCraft
extends CompatibilityModule {
    @Override
    public long doReceiveEnergy(Object handler, ForgeDirection direction, long energy, boolean doReceive) {
        if (handler instanceof IEnergySink) {
            if (this.doIsEnergyContainer(handler) && this.doGetEnergy(handler, direction) >= this.doGetMaxEnergy(handler, direction)) {
                return 0L;
            }
            int demand = (int)Math.min((double)((IEnergySink)handler).getMaxSafeInput(), ((IEnergySink)handler).demandedEnergyUnits());
            long send = (long)Math.min((double)demand, (double)energy * CompatibilityType.INDUSTRIALCRAFT.ratio);
            if (doReceive) {
                double rejected = ((IEnergySink)handler).injectEnergyUnits(direction, send);
                return (long)(Math.max((double)send - rejected, 0.0) * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
            }
            return (long)((double)send * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
        }
        return 0L;
    }

    @Override
    public long doExtractEnergy(Object handler, ForgeDirection direction, long energy, boolean doExtract) {
        if (handler instanceof IEnergySource) {
            long demand = (long)Math.min(((IEnergySource)handler).getOfferedEnergy(), (double)energy * CompatibilityType.INDUSTRIALCRAFT.ratio);
            if (doExtract) {
                ((IEnergySource)handler).drawEnergy(demand);
            }
            return (long)((double)demand * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
        }
        return 0L;
    }

    @Override
    public boolean doIsHandler(Object obj) {
        return obj instanceof IEnergySink || obj instanceof IEnergySource || obj instanceof IElectricItem;
    }

    @Override
    public boolean doCanConnect(Object obj, ForgeDirection direction, Object source) {
        try {
            if (!(source instanceof TileEntity)) {
                source = null;
            }
            if (obj instanceof IEnergySink && ((IEnergySink)obj).acceptsEnergyFrom((TileEntity)source, direction)) {
                return true;
            }
            if (obj instanceof IEnergySource && ((IEnergySource)obj).emitsEnergyTo((TileEntity)source, direction)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public long doChargeItem(ItemStack itemStack, long joules, boolean doCharge) {
        if (itemStack.func_77973_b() instanceof IElectricItem) {
            return (long)((double)ElectricItem.manager.charge(itemStack, (int)Math.ceil((double)joules * CompatibilityType.INDUSTRIALCRAFT.ratio), 4, true, !doCharge) * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
        }
        return 0L;
    }

    @Override
    public long doDischargeItem(ItemStack itemStack, long joules, boolean doDischarge) {
        IElectricItem item;
        if (itemStack.func_77973_b() instanceof IElectricItem && (item = (IElectricItem)itemStack.func_77973_b()).canProvideEnergy(itemStack)) {
            return (long)((double)ElectricItem.manager.discharge(itemStack, (int)Math.ceil((double)joules * CompatibilityType.INDUSTRIALCRAFT.ratio), 4, true, !doDischarge) * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
        }
        return 0L;
    }

    @Override
    public ItemStack doGetItemWithCharge(ItemStack itemStack, long energy) {
        ItemStack is = itemStack.func_77946_l();
        ElectricItem.manager.discharge(is, Integer.MAX_VALUE, 1, true, false);
        ElectricItem.manager.charge(is, (int)((double)energy * CompatibilityType.INDUSTRIALCRAFT.ratio), 1, true, false);
        return is;
    }

    @Override
    public boolean doIsEnergyContainer(Object obj) {
        return obj instanceof IEnergyStorage;
    }

    @Override
    public long doGetEnergy(Object obj, ForgeDirection direction) {
        return (long)((double)((IEnergyStorage)obj).getStored() * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
    }

    @Override
    public long doGetMaxEnergy(Object obj, ForgeDirection direction) {
        return (long)((double)((IEnergyStorage)obj).getCapacity() * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
    }

    @Override
    public long doGetEnergyItem(ItemStack is) {
        return (long)((double)ElectricItem.manager.getCharge(is) * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
    }

    @Override
    public long doGetMaxEnergyItem(ItemStack is) {
        return (long)((double)((IElectricItem)is.func_77973_b()).getMaxCharge(is) * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
    }
}

