/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import universalelectricity.api.net.IConnector;

public class ConnectionPathfinder<C extends IConnector> {
    public final Set<C> closedSet = new LinkedHashSet<C>();
    public final Set<C> results = new LinkedHashSet<C>();
    protected Class<? extends IConnector> connectorClass;
    protected final C targetConnector;
    protected final List<C> ignoreConnector;

    public ConnectionPathfinder(C targetConnector, C ... ignoreConnector) {
        this(null, (IConnector)targetConnector, (IConnector[])ignoreConnector);
    }

    public ConnectionPathfinder(Class<? extends IConnector> connectorClass, C targetConnector, C ... ignoreConnector) {
        this.targetConnector = targetConnector;
        this.connectorClass = connectorClass != null ? connectorClass : targetConnector.getClass();
        this.ignoreConnector = ignoreConnector != null ? Arrays.asList(ignoreConnector) : new ArrayList<C>();
    }

    public boolean findNodes(C currentNode) {
        this.closedSet.add(currentNode);
        if (this.onSearch(currentNode)) {
            return false;
        }
        for (IConnector node : this.getConnectedNodes(currentNode)) {
            if (this.closedSet.contains(node) || !this.findNodes(node)) continue;
            return true;
        }
        return false;
    }

    public Set<C> getConnectedNodes(C currentNode) {
        HashSet<IConnector> connectedNodes = new HashSet<IConnector>();
        if (currentNode != null && currentNode.getConnections() != null) {
            for (int i = 0; i < currentNode.getConnections().length; ++i) {
                Object obj = currentNode.getConnections()[i];
                if (obj == null || !this.connectorClass.isAssignableFrom(obj.getClass()) || this.ignoreConnector.contains(obj)) continue;
                connectedNodes.add((IConnector)obj);
            }
        }
        return connectedNodes;
    }

    public boolean onSearch(C node) {
        if (node == this.targetConnector) {
            this.results.add(node);
            return true;
        }
        return false;
    }

    public void reset() {
        this.results.clear();
        this.closedSet.clear();
    }
}

