/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.electricity.IElectricalNetwork;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.electricity.IVoltageOutput;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.vector.Vector3;
import universalelectricity.core.net.EnergyNetwork;

public class ElectricalNetwork
extends EnergyNetwork
implements IElectricalNetwork {
    private long voltage = 0L;
    private long newVoltage = 0L;
    private long currentCapacity = 0L;

    @Override
    public void update() {
        this.newVoltage = 0L;
        super.update();
        this.voltage = this.newVoltage;
        if (this.voltage <= 0L) {
            this.voltage = UniversalElectricity.DEFAULT_VOLTAGE;
        }
    }

    @Override
    public void reconstruct() {
        this.voltage = 0L;
        this.currentCapacity = Long.MAX_VALUE;
        super.reconstruct();
        if (this.voltage <= 0L) {
            this.voltage = UniversalElectricity.DEFAULT_VOLTAGE;
        }
    }

    @Override
    protected void reconstructConnector(IConductor conductor) {
        super.reconstructConnector(conductor);
        this.currentCapacity = Math.min(this.currentCapacity, conductor.getCurrentCapacity());
    }

    @Override
    protected void reconstructHandler(IConductor conductor, Object obj, ForgeDirection side) {
        super.reconstructHandler(conductor, obj, side);
        if (obj instanceof IVoltageOutput && !(obj instanceof IConductor)) {
            this.voltage = Math.max(this.voltage, ((IVoltageOutput)obj).getVoltageOutput(side));
        }
    }

    @Override
    public long addEnergyToHandler(Object handler, ForgeDirection side, long energy, boolean doPower) {
        if (handler instanceof IVoltageOutput) {
            this.newVoltage = Math.max(this.newVoltage, ((IVoltageOutput)handler).getVoltageOutput(side));
        }
        if (handler instanceof IVoltageInput && ((IVoltageInput)handler).getVoltageInput(side) != this.getVoltage()) {
            ((IVoltageInput)handler).onWrongVoltage(side, this.voltage);
        }
        return super.addEnergyToHandler(handler, side, energy, doPower);
    }

    @Override
    public long getVoltage() {
        return this.voltage <= 0L ? UniversalElectricity.DEFAULT_VOLTAGE : this.voltage;
    }

    @Override
    public long produce(IConductor conductor, ForgeDirection from, long amount, boolean doReceive) {
        TileEntity tile = null;
        if (conductor instanceof TileEntity) {
            tile = new Vector3((TileEntity)conductor).translate(from).getTileEntity((IBlockAccess)((TileEntity)conductor).field_70331_k);
        }
        if (tile instanceof IVoltageOutput && !(tile instanceof IConductor) && ((IVoltageOutput)tile).getVoltageOutput(from) < this.voltage) {
            return 0L;
        }
        return super.produce(conductor, from, amount, doReceive);
    }
}

