/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.INodeNetwork;
import universalelectricity.core.net.Network;

public abstract class NodeNetwork<N extends INodeNetwork, C extends IConnector, A>
extends Network<N, C>
implements INodeNetwork<N, C, A> {
    private final Set<A> nodes = Collections.newSetFromMap(new WeakHashMap());

    public NodeNetwork(Class<? extends C> type) {
        super(type);
    }

    public void add(A battery) {
        this.nodes.add(battery);
    }

    public void remove(A battery) {
        this.nodes.remove(battery);
    }

    @Override
    public Set<A> getNodes() {
        return this.nodes;
    }

    @Override
    public N merge(N network) {
        INodeNetwork newNetwork = (INodeNetwork)super.merge(network);
        if (newNetwork != null) {
            network.getNodes().clear();
            this.getNodes().clear();
            return (N)newNetwork;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.hashCode() + ", Nodes: " + this.nodes.size() + ", Connectors: " + this.getConnectors().size() + "]";
    }
}

