/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.fluids;

import buildcraft.core.fluids.Tank;
import com.google.common.collect.ForwardingList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TankManager<T extends Tank>
extends ForwardingList<T>
implements IFluidHandler,
List<T> {
    private List<T> tanks = new ArrayList<T>();

    public TankManager() {
    }

    public TankManager(T ... tanks) {
        this.addAll(Arrays.asList(tanks));
    }

    protected List<T> delegate() {
        return this.tanks;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        for (Tank tank : this.tanks) {
            int used = tank.fill(resource, doFill);
            if (used <= 0) continue;
            return used;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        for (Tank tank : this.tanks) {
            FluidStack drained;
            if (!resource.isFluidEqual(tank.getFluid()) || (drained = tank.drain(resource.amount, doDrain)) == null || drained.amount <= 0) continue;
            return drained;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        for (Tank tank : this.tanks) {
            FluidStack drained = tank.drain(maxDrain, doDrain);
            if (drained == null || drained.amount <= 0) continue;
            return drained;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            info[i] = ((Tank)((Object)this.get(i))).getInfo();
        }
        return info;
    }

    public void writeToNBT(NBTTagCompound data) {
        for (Tank tank : this.tanks) {
            tank.writeToNBT(data);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        for (Tank tank : this.tanks) {
            tank.readFromNBT(data);
        }
    }

    public void writeData(DataOutputStream data) throws IOException {
        for (Tank tank : this.tanks) {
            FluidStack fluidStack = tank.getFluid();
            if (fluidStack != null && fluidStack.getFluid() != null) {
                data.writeShort(fluidStack.getFluid().getID());
                data.writeInt(fluidStack.amount);
                data.writeInt(fluidStack.getFluid().getColor(fluidStack));
                continue;
            }
            data.writeShort(-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        for (Tank tank : this.tanks) {
            short fluidId = data.readShort();
            if (fluidId > 0) {
                tank.setFluid(new FluidStack((int)fluidId, data.readInt()));
                tank.colorRenderCache = data.readInt();
                continue;
            }
            tank.setFluid(null);
            tank.colorRenderCache = 0xFFFFFF;
        }
    }
}

