/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.core.triggers.ActionTriggerIconProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public abstract class BCTrigger
implements ITrigger {
    protected final int legacyId;
    protected final String uniqueTag;

    public BCTrigger(int legacyId, String uniqueTag) {
        this.legacyId = legacyId;
        this.uniqueTag = uniqueTag;
        ActionManager.registerTrigger(this);
    }

    @Override
    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Override
    public int getLegacyId() {
        return this.legacyId;
    }

    public int getIconIndex() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return ActionTriggerIconProvider.INSTANCE.getIcon(this.getIconIndex());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public boolean requiresParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        return false;
    }

    @Override
    public final ITriggerParameter createParameter() {
        return new TriggerParameter();
    }
}

