/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.network.TileNetworkData;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeLogicWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsWood
extends Pipe<PipeTransportFluids>
implements IPowerReceptor {
    @TileNetworkData
    public int liquidToExtract;
    private PowerHandler powerHandler;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeFluidsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    long lastMining = 0L;
    boolean lastPower = false;
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            if (!(tile instanceof IFluidHandler)) {
                return false;
            }
            return PipeManager.canExtractFluids(this.pipe, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        }
    };

    public PipeFluidsWood(int itemID) {
        super(new PipeTransportFluids(), itemID);
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.powerHandler.configure(1.0f, 100.0f, 1.0f, 250.0f);
        this.powerHandler.configurePowerPerdition(0, 0);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange(blockId);
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (this.powerHandler.getEnergyStored() <= 0.0f) {
            return;
        }
        World w = this.container.field_70331_k;
        int meta = this.container.func_70322_n();
        if (meta > 5) {
            return;
        }
        TileEntity tile = this.container.getTile(ForgeDirection.getOrientation((int)meta));
        if (tile instanceof IFluidHandler) {
            if (!PipeManager.canExtractFluids(this, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)) {
                return;
            }
            if (this.liquidToExtract <= 1000) {
                this.liquidToExtract = (int)((float)this.liquidToExtract + this.powerHandler.useEnergy(1.0f, 1.0f, true) * 1000.0f);
            }
        }
        this.powerHandler.useEnergy(1.0f, 1.0f, true);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void updateEntity() {
        ForgeDirection side;
        TileEntity tile;
        super.updateEntity();
        int meta = this.container.func_70322_n();
        if (this.liquidToExtract > 0 && meta < 6 && (tile = this.container.getTile(side = ForgeDirection.getOrientation((int)meta))) instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)tile;
            int flowRate = ((PipeTransportFluids)this.transport).flowRate;
            FluidStack extracted = fluidHandler.drain(side.getOpposite(), this.liquidToExtract > flowRate ? flowRate : this.liquidToExtract, false);
            int inserted = 0;
            if (extracted != null) {
                inserted = ((PipeTransportFluids)this.transport).fill(side, extracted, true);
                fluidHandler.drain(side.getOpposite(), inserted, true);
            }
            this.liquidToExtract -= inserted;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_70322_n();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        int meta = this.container.func_70322_n();
        return super.outputOpen(to) && meta != to.ordinal();
    }
}

