/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.buildcraft;

import buildcraft.api.recipes.AssemblyRecipe;
import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class AssemblyRecipeHandler2
extends LiquidTemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};
    public static LinkedList assemblyRecipes;

    @Override
    public String getRecipeId() {
        return "buildcraft.assembly";
    }

    public String getRecipeName() {
        return "Assembly Table";
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public String getOverlayIdentifier() {
        return "buildcraft.assemblyTable";
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public void drawExtras(int recipe) {
        Integer time = Math.round(((CachedAssemblyRecipe)((Object)this.arecipes.get((int)recipe))).energy);
        String costString = time.toString();
        GuiDraw.drawStringC((String)costString, (int)110, (int)9, (int)-8355712, (boolean)false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), this.getRecipeId(), new Object[0]));
    }

    @Override
    public void loadSameRecipeId() {
        for (AssemblyRecipe irecipe : AssemblyRecipe.assemblyRecipes) {
            this.arecipes.add(new CachedAssemblyRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (AssemblyRecipe irecipe : AssemblyRecipe.assemblyRecipes) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)irecipe.output)) continue;
            this.arecipes.add(new CachedAssemblyRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (AssemblyRecipe irecipe : AssemblyRecipe.assemblyRecipes) {
            CachedAssemblyRecipe recipe = new CachedAssemblyRecipe(irecipe);
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            this.setIngredientPermutationNBT(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedAssemblyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList<PositionedStack> ingredients;
        PositionedStack result;
        float energy;

        public CachedAssemblyRecipe(AssemblyRecipe recipe) {
            super((TemplateRecipeHandler)AssemblyRecipeHandler2.this);
            this.result = new PositionedStack((Object)recipe.output, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(recipe.input);
            this.energy = recipe.energy;
        }

        public void setIngredients(Object[] items) {
            int count = 0;
            for (int ingred = 0; ingred < items.length; ++ingred) {
                PositionedStack stack = null;
                if (items[ingred] instanceof ItemStack) {
                    stack = new PositionedStack(items[ingred], 25 + stackorder[count][0] * 18, 6 + stackorder[count][1] * 18);
                } else if (items[ingred] instanceof ArrayList) {
                    int amount = (Integer)items[ingred + 1];
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < ((ArrayList)items[ingred]).size(); ++i) {
                        ItemStack t = ((ItemStack)((ArrayList)items[ingred]).get(i)).func_77946_l();
                        t.field_77994_a = amount;
                        stacks.add(t);
                    }
                    stack = new PositionedStack(stacks, 25 + stackorder[count][0] * 18, 6 + stackorder[count][1] * 18);
                    ++ingred;
                }
                if (stack == null) continue;
                ++count;
                this.ingredients.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AssemblyRecipeHandler2.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

