/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.ic2_exp;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import mods.neiplugins.lists.GuiList;
import mods.neiplugins.lists.IListElement;
import mods.neiplugins.lists.SimpleListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class GuiCropCrossingList
extends GuiList {
    private static ArrayList<CrossingResult> calcResult;

    protected GuiCropCrossingList(GuiContainer prevgui, String title, ArrayList<? extends IListElement> list) {
        super(prevgui, title, list);
    }

    @Override
    public int getElementsOffset() {
        return 10;
    }

    @Override
    public int getElementHeight() {
        return 10;
    }

    @Override
    protected void drawBackground(int index, boolean empty, boolean hovered) {
    }

    public static int calculateRatioFor(CropCard a, CropCard b) {
        int i;
        if (a == b) {
            return 500;
        }
        int value = 0;
        for (i = 0; i < 5; ++i) {
            int c = a.stat(i) - b.stat(i);
            if (c < 0) {
                c *= -1;
            }
            switch (c) {
                default: {
                    --value;
                }
                case 0: {
                    value += 2;
                }
                case 1: {
                    ++value;
                }
                case 2: 
            }
        }
        for (i = 0; i < a.attributes().length; ++i) {
            for (int j = 0; j < b.attributes().length; ++j) {
                if (!a.attributes()[i].equalsIgnoreCase(b.attributes()[j])) continue;
                value += 5;
            }
        }
        if (b.tier() < a.tier() - 1) {
            value -= 2 * (a.tier() - b.tier());
        }
        if (b.tier() - 3 > a.tier()) {
            value -= b.tier() - a.tier();
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    public static ArrayList<CrossingResult> getCrossingResults() {
        if (calcResult != null) {
            return calcResult;
        }
        calcResult = new ArrayList();
        CropCard[] crops = Crops.instance.getCropList();
        for (int i = 1; i < crops.length; ++i) {
            if (crops[i] == null) continue;
            for (int j = i; j < crops.length; ++j) {
                if (crops[j] == null) continue;
                HashMap<Integer, Integer> products = new HashMap<Integer, Integer>();
                for (int k = 1; k < crops.length; ++k) {
                    int ratio;
                    if (crops[k] == null || k == i || k == j || (ratio = GuiCropCrossingList.calculateRatioFor(crops[k], crops[i]) + GuiCropCrossingList.calculateRatioFor(crops[k], crops[j])) <= 0) continue;
                    products.put(k, ratio);
                }
                if (products.size() <= 0) continue;
                calcResult.add(new CrossingResult(i, j, products));
            }
        }
        return calcResult;
    }

    public static boolean showList(String title) {
        ArrayList<ListElement1> list = new ArrayList<ListElement1>();
        CropCard[] crops = Crops.instance.getCropList();
        for (int i = 1; i < crops.length; ++i) {
            if (crops[i] == null) continue;
            list.add(new ListElement1(i));
        }
        if (list.isEmpty()) {
            return false;
        }
        return GuiList.showList(title, list);
    }

    public static boolean showCrossingList(int cropId) {
        ArrayList<ListElement2> list = new ArrayList<ListElement2>();
        ArrayList<CrossingResult> crossingResults = GuiCropCrossingList.getCrossingResults();
        for (CrossingResult result : crossingResults) {
            float chance = result.getChance(cropId);
            if (chance <= 0.0f) continue;
            list.add(new ListElement2(result.name(), chance));
        }
        Collections.sort(list);
        if (list.isEmpty()) {
            return false;
        }
        Minecraft mc = NEIClientUtils.mc();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return false;
        }
        GuiContainer prevscreen = (GuiContainer)mc.field_71462_r;
        NEIClientUtils.overlayScreen((GuiScreen)new GuiCropCrossingList(prevscreen, Crops.instance.getCropList()[cropId].name(), list));
        return true;
    }

    static class ListElement2
    extends SimpleListElement
    implements Comparable<ListElement2> {
        static DecimalFormat chanceFormat1 = new DecimalFormat("0.00");
        static DecimalFormat chanceFormat2 = new DecimalFormat("0.000");
        float chance;

        ListElement2(String title, float chance) {
            super(ListElement2.formatChance(chance) + "% " + title);
            this.chance = chance;
        }

        public static String formatChance(float chance) {
            if (chance >= 0.1f) {
                return chanceFormat1.format(chance * 100.0f);
            }
            return chanceFormat2.format(chance * 100.0f);
        }

        @Override
        public int compareTo(ListElement2 o) {
            return -Float.valueOf(this.chance).compareTo(Float.valueOf(o.chance));
        }

        @Override
        public void draw(Dimension size) {
            GuiDraw.drawString((String)this.getTitle(), (int)-10, (int)((size.height - 8) / 2), (int)0x404040, (boolean)false);
        }
    }

    static class ListElement1
    extends SimpleListElement {
        int id;

        ListElement1(int id) {
            super(Crops.instance.getCropList()[id].name());
            this.id = id;
        }

        @Override
        public boolean click(int button) {
            return GuiCropCrossingList.showCrossingList(this.id);
        }
    }

    static class CrossingResult {
        int total;
        int parent1;
        int parent2;
        HashMap<Integer, Integer> products;

        CrossingResult(int parent1, int parent2, HashMap<Integer, Integer> products) {
            this.parent1 = parent1;
            this.parent2 = parent2;
            this.products = products;
            this.total = 0;
            for (Integer chance : products.values()) {
                this.total += chance.intValue();
            }
        }

        float getChance(int cropId) {
            Integer chance = this.products.get(cropId);
            if (chance == null || this.total == 0) {
                return 0.0f;
            }
            return 1.0f * (float)chance.intValue() / (float)this.total;
        }

        String name() {
            CropCard[] crops = Crops.instance.getCropList();
            return crops[this.parent1].name() + " + " + crops[this.parent2].name();
        }
    }
}

