/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityQuadruped;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntityCow
extends NecroEntityQuadruped {
    public NecroEntityCow() {
        this("Cow", 12);
    }

    public NecroEntityCow(String name, int size) {
        super(name, size);
        this.headItem = ItemBodyPart.getItemStackFromName("Cow Head", 1);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Cow Torso", 1);
        this.armItem = ItemBodyPart.getItemStackFromName("Cow Arm", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Cow Legs", 1);
        this.texture = new bjo("textures/entity/cow/cow.png");
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(yc.bk);
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart head = new BodyPart(this, model, 0, 0);
        head.a(-4.0f, -4.0f, -4.0f, 8, 8, 6, 0.0f);
        head.a(22, 0).a(-5.0f, -5.0f, -4.0f, 1, 3, 1, 0.0f);
        head.a(22, 0).a(4.0f, -5.0f, -4.0f, 1, 3, 1, 0.0f);
        head.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{head};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, 16 - this.size, -14.0f};
        float[] armLeftPos = new float[]{-1.0f, 12.0f, -10.0f};
        float[] armRightPos = new float[]{5.0f, 12.0f, -10.0f};
        BodyPart body = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 18, 4);
        body.a(-2.0f, -12.0f, -12.0f, 12, 18, 10, 0.0f);
        body.a(52, 0).a(2.0f, 2.0f, -13.0f, 4, 6, 1);
        body.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{body};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, -2.0f, 0.0f};
        BodyPart legLeft = new BodyPart(this, torsoPos, model, 0, 16);
        legLeft.a(-2.0f, 0.0f, -2.0f, 4, this.size, 4, 0.0f);
        legLeft.a(-4.0f, 22.0f - (float)this.size, 2.0f);
        BodyPart legRight = new BodyPart(this, torsoPos, model, 0, 16);
        legRight.a(-2.0f, 0.0f, -2.0f, 4, this.size, 4, 0.0f);
        legRight.a(4.0f, 22.0f - (float)this.size, 2.0f);
        legLeft.b(this.textureWidth, this.textureHeight);
        legRight.b(this.textureWidth, this.textureHeight);
        legLeft.i = true;
        return new BodyPart[]{legLeft, legRight};
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(1.0);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(6.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.ArmLeft) {
            this.armLeft[0].attributes.b(tp.a).a(1.0);
            this.armLeft[0].attributes.b(tp.b).a(0.0);
            this.armLeft[0].attributes.b(tp.c).a(0.0);
            this.armLeft[0].attributes.b(tp.d).a(0.175);
            this.armLeft[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.ArmRight) {
            this.armRight[0].attributes.b(tp.a).a(1.0);
            this.armRight[0].attributes.b(tp.b).a(0.0);
            this.armRight[0].attributes.b(tp.c).a(0.0);
            this.armRight[0].attributes.b(tp.d).a(0.175);
            this.armRight[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(1.0);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.35);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

