/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityBiped;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntityEnderman
extends NecroEntityBiped {
    public NecroEntityEnderman() {
        super("Enderman");
        this.headItem = ItemBodyPart.getItemStackFromName("Enderman Head", 1);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Enderman Torso", 1);
        this.armItem = ItemBodyPart.getItemStackFromName("Enderman Arm", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Enderman Legs", 1);
        this.texture = new bjo("textures/entity/enderman/enderman.png");
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(yc.bp);
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart head = new BodyPart(this, model, 0, 0);
        head.a(-4.0f, -7.0f, -4.0f, 8, 8, 8, 0.0f);
        head.b(this.textureWidth, this.textureHeight);
        BodyPart bipedHeadwear = new BodyPart(this, model, 0, 16);
        bipedHeadwear.a(-4.0f, -3.0f, -4.0f, 8, 8, 8, -0.5f);
        return new BodyPart[]{head, bipedHeadwear};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, -4.0f, 2.0f};
        float[] armLeftPos = new float[]{-4.0f, 0.0f, 2.0f};
        float[] armRightPos = new float[]{8.0f, 0.0f, 2.0f};
        BodyPart torso = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 32, 16);
        torso.a(0.0f, 0.0f, 0.0f, 8, 12, 4, 0.0f);
        return new BodyPart[]{torso};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, -18.0f, 0.0f};
        BodyPart legRight = new BodyPart(this, torsoPos, model, 56, 0);
        legRight.a(-1.0f, -4.0f, 1.0f, 2, 30, 2, 0.0f);
        legRight.a(-2.0f, -2.0f, 0.0f);
        BodyPart legLeft = new BodyPart(this, torsoPos, model, 56, 0);
        legLeft.i = true;
        legLeft.a(-1.0f, -4.0f, 1.0f, 2, 30, 2, 0.0f);
        legLeft.a(2.0f, -2.0f, 0.0f);
        return new BodyPart[]{legLeft, legRight};
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        BodyPart bipedLeftArm = new BodyPart(this, model, 56, 0);
        bipedLeftArm.i = true;
        bipedLeftArm.a(2.0f, 0.0f, -1.0f, 2, 30, 2, 0.0f);
        return new BodyPart[]{bipedLeftArm};
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        BodyPart bipedRightArm = new BodyPart(this, model, 56, 0);
        bipedRightArm.a(0.0f, 0.0f, -1.0f, 2, 30, 2, 0.0f);
        return new BodyPart[]{bipedRightArm};
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn entity, BodyPart[] part, BodyPartLocation location) {
        super.setRotationAngles(par1, par2, par3, par4, par5, par6, entity, part, location);
        if (location == BodyPartLocation.Head) {
            part[0].e = -0.0f;
            part[0].d = -0.0f;
            part[1].c = part[0].c;
            part[1].d = part[0].d;
            part[1].e = part[0].e;
            part[1].f = part[0].f;
            part[1].g = part[0].g;
            part[1].h = part[0].h;
        }
        if (location == BodyPartLocation.Legs) {
            part[0].f -= 0.0f;
            part[1].f -= 0.0f;
            part[0].f = (float)((double)part[0].f * 0.5);
            part[1].f = (float)((double)part[1].f * 0.5);
            if (part[0].f > 0.4f) {
                part[0].f = 0.4f;
            }
            if (part[0].f < -0.4f) {
                part[0].f = -0.4f;
            }
            if (part[1].f > 0.4f) {
                part[1].f = 0.4f;
            }
            if (part[1].f < -0.4f) {
                part[1].f = -0.4f;
            }
        }
        if (location == BodyPartLocation.ArmRight) {
            part[0].f = (float)((double)part[0].f * 0.5);
            if (part[0].f > 0.4f) {
                part[0].f = 0.4f;
            }
            if (part[0].f < -0.4f) {
                part[0].f = -0.4f;
            }
        }
        if (location == BodyPartLocation.ArmRight) {
            part[0].f = (float)((double)part[0].f * 0.5);
            if (part[0].f > 0.4f) {
                part[0].f = 0.4f;
            }
            if (part[0].f < -0.4f) {
                part[0].f = -0.4f;
            }
        }
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(4.0);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(24.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.ArmLeft) {
            this.armLeft[0].attributes.b(tp.a).a(4.0);
            this.armLeft[0].attributes.b(tp.b).a(0.0);
            this.armLeft[0].attributes.b(tp.c).a(0.0);
            this.armLeft[0].attributes.b(tp.d).a(0.0);
            this.armLeft[0].attributes.b(tp.e).a(3.5);
        } else if (location == BodyPartLocation.ArmRight) {
            this.armRight[0].attributes.b(tp.a).a(4.0);
            this.armRight[0].attributes.b(tp.b).a(0.0);
            this.armRight[0].attributes.b(tp.c).a(0.0);
            this.armRight[0].attributes.b(tp.d).a(0.0);
            this.armRight[0].attributes.b(tp.e).a(3.5);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(4.0);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.3);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

