/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.ISaddleAble;
import com.sirolf2009.necroapi.NecroEntityBase;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntitySpider
extends NecroEntityBase
implements ISaddleAble {
    public NecroEntitySpider(String name) {
        super(name);
        this.headItem = ItemBodyPart.getItemStackFromName("Spider Head", 1);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Spider Torso", 1);
        this.armItem = ItemBodyPart.getItemStackFromName("Spider Arm", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Spider Legs", 1);
        this.texture = new bjo("textures/entity/spider/spider.png");
        this.hasArms = false;
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(yc.bw);
    }

    public NecroEntitySpider() {
        this("Spider");
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart spiderHead = new BodyPart(this, model, 32, 4);
        spiderHead.a(-4.0f, -4.0f, -6.0f, 8, 8, 8, 0.0f);
        return new BodyPart[]{spiderHead};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, 8.0f, -7.0f};
        float[] armLeftPos = new float[]{-1.0f, 10.0f, -6.0f};
        float[] armRightPos = new float[]{5.0f, 10.0f, -6.0f};
        BodyPart spiderNeck = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 0, 0);
        spiderNeck.a(1.0f, 5.0f, -6.0f, 6, 6, 6, 0.0f);
        BodyPart spiderBody = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 0, 12);
        spiderBody.a(-1.0f, 4.0f, 0.0f, 10, 8, 12, 0.0f);
        return new BodyPart[]{spiderBody, spiderNeck};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, 6.0f, 3.0f};
        BodyPart spiderLeg1 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg1.a(-15.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg1.a(-4.0f, 15.0f, 2.0f);
        BodyPart spiderLeg2 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg2.a(-1.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg2.a(4.0f, 15.0f, 2.0f);
        BodyPart spiderLeg3 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg3.a(-15.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg3.a(-4.0f, 15.0f, 1.0f);
        BodyPart spiderLeg4 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg4.a(-1.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg4.a(4.0f, 15.0f, 1.0f);
        BodyPart spiderLeg5 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg5.a(-15.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg5.a(-4.0f, 15.0f, 0.0f);
        BodyPart spiderLeg6 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg6.a(-1.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg6.a(4.0f, 15.0f, 0.0f);
        BodyPart spiderLeg7 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg7.a(-15.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg7.a(-4.0f, 15.0f, -1.0f);
        BodyPart spiderLeg8 = new BodyPart(this, torsoPos, model, 18, 0);
        spiderLeg8.a(-1.0f, -1.0f, -1.0f, 16, 2, 2, 0.0f);
        spiderLeg8.a(4.0f, 15.0f, -1.0f);
        return new BodyPart[]{spiderLeg1, spiderLeg2, spiderLeg3, spiderLeg4, spiderLeg5, spiderLeg6, spiderLeg7, spiderLeg8};
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        return null;
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        return null;
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn entity, BodyPart[] part, BodyPartLocation location) {
        if (location == BodyPartLocation.Legs) {
            float var8 = 0.7853982f;
            part[0].h = -var8;
            part[1].h = var8;
            part[2].h = -var8 * 0.74f;
            part[3].h = var8 * 0.74f;
            part[4].h = -var8 * 0.74f;
            part[5].h = var8 * 0.74f;
            part[6].h = -var8;
            part[7].h = var8;
            float var9 = -0.0f;
            float var10 = 0.3926991f;
            part[0].g = var10 * 2.0f + var9;
            part[1].g = -var10 * 2.0f - var9;
            part[2].g = var10 * 1.0f + var9;
            part[3].g = -var10 * 1.0f - var9;
            part[4].g = -var10 * 1.0f + var9;
            part[5].g = var10 * 1.0f - var9;
            part[6].g = -var10 * 2.0f + var9;
            part[7].g = var10 * 2.0f - var9;
            float var11 = -(ls.b((float)(par1 * 0.6662f * 2.0f + 0.0f)) * 0.4f) * par2;
            float var12 = -(ls.b((float)(par1 * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * par2;
            float var13 = -(ls.b((float)(par1 * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * par2;
            float var14 = -(ls.b((float)(par1 * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * par2;
            float var15 = Math.abs(ls.a((float)(par1 * 0.6662f + 0.0f)) * 0.4f) * par2;
            float var16 = Math.abs(ls.a((float)(par1 * 0.6662f + (float)Math.PI)) * 0.4f) * par2;
            float var17 = Math.abs(ls.a((float)(par1 * 0.6662f + 1.5707964f)) * 0.4f) * par2;
            float var18 = Math.abs(ls.a((float)(par1 * 0.6662f + 4.712389f)) * 0.4f) * par2;
            part[0].g += var11;
            part[1].g += -var11;
            part[2].g += var12;
            part[3].g += -var12;
            part[4].g += var13;
            part[5].g += -var13;
            part[6].g += var14;
            part[7].g += -var14;
            part[0].h += var15;
            part[1].h += -var15;
            part[2].h += var16;
            part[3].h += -var16;
            part[4].h += var17;
            part[5].h += -var17;
            part[6].h += var18;
            part[7].h += -var18;
        }
    }

    @Override
    public bjo getSaddleTex() {
        return new bjo("textures/entities/spidersaddle.png");
    }

    @Override
    public int riderHeight() {
        return 0;
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(2.0);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(2.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(12.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(2.0);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.8);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

