/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.fossilsarch.common.ai.DinoAIGrowup;
import net.fossilsarch.common.ai.DinoAIStarvation;
import net.fossilsarch.common.ai.WaterDinoAINearestAttackableTarget;
import net.fossilsarch.common.ai.WaterDinoAISwimming;
import net.fossilsarch.common.ai.WaterDinoAIWander;
import net.fossilsarch.common.dinos.IWaterDino;
import net.fossilsarch.common.entity.EntityDinosaurce;
import net.fossilsarch.common.entity.EntityNautilus;
import net.fossilsarch.common.io.EnumDinoType;
import net.fossilsarch.common.io.EnumOrderType;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityMosasaurus
extends EntityDinosaurce
implements IWaterDino {
    public final int Areas = 60;
    public final float HuntLimit = this.getHungerLimit() * 4 / 5;
    private boolean looksWithInterest;
    private float field_25048_b;
    private float field_25054_c;
    private boolean field_25052_g;
    public float TargetY = 0.0f;

    public EntityMosasaurus(World world) {
        this(world, EntityMosasaurus.randomSpawnAge(world.field_73012_v));
        this.OrderStatus = EnumOrderType.FreeMove;
    }

    public EntityMosasaurus(World world, int age) {
        super(world);
        this.setDinoAge(age);
        this.SelfType = EnumDinoType.Mosasaurus;
        this.looksWithInterest = false;
        this.attackStrength = 4.0f + 2.0f * (float)this.getDinoAge();
        this.func_70105_a(1.0f, 1.0f);
        this.func_70606_j(10 + this.getDinoAge());
        this.func_70661_as().func_75495_e(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIGrowup(this, 8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIStarvation(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new WaterDinoAIWander(this, 1.0f, 0.003f));
        this.field_70714_bg.func_75776_a(4, new WaterDinoAISwimming(this, true, 0.09374999f, 0.018749999f).setDiveAtNight());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new WaterDinoAINearestAttackableTarget((EntityCreature)this, EntityNautilus.class, 0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new WaterDinoAINearestAttackableTarget((EntityCreature)this, EntitySquid.class, 0, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new WaterDinoAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new WaterDinoAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
    }

    public float func_70689_ay() {
        float speed = super.func_70689_ay();
        speed *= 0.5f + 0.4f * (float)this.getDinoAge();
        if (this.isSelfAngry()) {
            speed *= 2.0f;
        }
        return speed;
    }

    private static int randomSpawnAge(Random random) {
        return random.nextInt(2) + 7;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public int getHungerLimit() {
        return 500;
    }

    @Override
    public boolean func_70650_aV() {
        return !this.isModelized() && this.field_70153_n == null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Angry", this.isSelfAngry());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSelfAngry(nbttagcompound.func_74767_n("Angry"));
        this.InitSize();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        return "";
    }

    protected String func_70621_aR() {
        return "";
    }

    protected String func_70673_aS() {
        return "";
    }

    @Override
    protected void func_70626_be() {
        if (this.field_70153_n == null) {
            super.func_70626_be();
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean isOnSurface() {
        AxisAlignedBB boxTmp = this.field_70121_D;
        AxisAlignedBB checkBoxLower = AxisAlignedBB.func_72330_a((double)boxTmp.field_72340_a, (double)boxTmp.field_72338_b, (double)boxTmp.field_72339_c, (double)boxTmp.field_72336_d, (double)(boxTmp.field_72337_e / 2.0), (double)boxTmp.field_72334_f);
        AxisAlignedBB checkBoxUpper = AxisAlignedBB.func_72330_a((double)boxTmp.field_72340_a, (double)(boxTmp.field_72338_b + (boxTmp.field_72337_e - boxTmp.field_72338_b) / 4.0), (double)boxTmp.field_72339_c, (double)boxTmp.field_72336_d, (double)boxTmp.field_72337_e, (double)boxTmp.field_72334_f);
        return this.field_70170_p.func_72830_b(checkBoxLower, Material.field_76244_g) && this.field_70170_p.func_72830_b(checkBoxLower, Material.field_76249_a);
    }

    public void func_70612_e(float f, float f1) {
        if (this.func_70090_H()) {
            if (this.isOnSurface() && this.field_70181_x > 0.0) {
                this.field_70181_x = 0.0;
            }
            double d = this.field_70163_u;
            this.func_70060_a(f, f1, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else if (this.func_70058_J()) {
            double d1 = this.field_70163_u;
            this.func_70060_a(f, f1, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d1, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else {
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.5460001f;
                int i = this.field_70170_p.func_72798_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                if (i > 0) {
                    f2 = Block.field_71973_m[i].field_72016_cq * 0.91f;
                }
            }
            float f3 = 0.1627714f / (f2 * f2 * f2);
            float f4 = this.field_70122_E ? this.func_70689_ay() * f3 : this.field_70747_aH;
            this.func_70060_a(f, f1, f4);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.5460001f;
                int j = this.field_70170_p.func_72798_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                if (j > 0) {
                    f2 = Block.field_71973_m[j].field_72016_cq * 0.91f;
                }
            }
            if (this.func_70617_f_()) {
                float f5 = 0.15f;
                if (this.field_70159_w < (double)(-f5)) {
                    this.field_70159_w = -f5;
                }
                if (this.field_70159_w > (double)f5) {
                    this.field_70159_w = f5;
                }
                if (this.field_70179_y < (double)(-f5)) {
                    this.field_70179_y = -f5;
                }
                if (this.field_70179_y > (double)f5) {
                    this.field_70179_y = f5;
                }
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
                if (this.func_70093_af() && this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && this.func_70617_f_()) {
                this.field_70181_x = 0.2;
            }
            if (!this.func_70090_H()) {
                this.field_70181_x -= 0.08;
            }
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d2 = this.field_70165_t - this.field_70169_q;
        double d3 = this.field_70161_v - this.field_70166_s;
        float f6 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3)) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.field_70721_aZ += (f6 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public void func_70636_d() {
        if (this.field_70181_x <= 0.0 && this.func_70090_H()) {
            this.field_70181_x = this.func_70661_as().func_75500_f() ? (double)-0.00375f : -0.01874999888241291;
        }
        this.attackStrength = 4.0f + 2.0f * (float)this.getDinoAge();
        super.func_70636_d();
    }

    public boolean getSelfShaking() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.2f;
    }

    public int func_70646_bf() {
        if (this.isSelfSitting()) {
            return 20;
        }
        return super.func_70646_bf();
    }

    @Override
    public void getPathOrWalkableBlock(Entity entity, float f) {
        PathEntity pathentity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, true, false, true, false);
        if (pathentity == null && f > 12.0f) {
            this.TargetY = (float)entity.field_70163_u;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t) - 2;
            int j = MathHelper.func_76128_c((double)entity.field_70161_v) - 2;
            int k = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.field_70170_p.func_72809_s(i + l, k - 1, j + i1) || this.field_70170_p.func_72809_s(i + l, k, j + i1) || this.field_70170_p.func_72809_s(i + l, k + 1, j + i1)) continue;
                    this.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.field_70177_z, this.field_70125_A);
                    return;
                }
            }
        } else {
            this.func_70778_a(pathentity);
        }
    }

    protected boolean func_70780_i() {
        return this.isSelfSitting() || this.field_25052_g;
    }

    protected Entity func_70782_k() {
        if (this.isSelfAngry()) {
            return this.field_70170_p.func_72890_a((Entity)this, 16.0);
        }
        return null;
    }

    protected void func_70785_a(Entity entity, float f) {
        if ((double)f > (double)this.field_70130_N * 1.6 && f < 60.0f && entity.func_70090_H()) {
            double d = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
            this.field_70159_w = d / (double)f1 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
            this.field_70179_y = d1 / (double)f1 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
            this.TargetY = (float)entity.field_70163_u;
        } else if ((double)f <= (double)this.field_70130_N * 1.6 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.attackStrength);
        }
    }

    public void func_70074_a(EntityLivingBase entityliving) {
        super.func_70074_a(entityliving);
        if (entityliving instanceof EntityPig) {
            this.HandleEating(30);
        } else if (entityliving instanceof EntitySheep) {
            this.HandleEating(35);
        } else if (entityliving instanceof EntityCow) {
            this.HandleEating(50);
        } else if (entityliving instanceof EntityChicken) {
            this.HandleEating(20);
        } else if (entityliving instanceof EntityMob) {
            this.HandleEating(20);
        } else if (entityliving instanceof EntityNautilus) {
            this.HandleEating(100);
        } else if (entityliving instanceof EntityPlayer) {
            this.HandleEating(100);
        } else if (entityliving instanceof EntityCreature) {
            this.HandleEating(20);
        }
        this.heal(5);
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (FMLCommonHandler.instance().getSide().isClient() && itemstack != null && itemstack.field_77993_c == mod_Fossil.DinoPedia.field_77779_bT) {
            EntityDinosaurce.pediaingDino = this;
            mod_Fossil.callGUI(entityplayer, 4, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        if (itemstack != null && itemstack.field_77993_c == mod_Fossil.ChickenEss.field_77779_bT) {
            if (this.getDinoAge() >= 8 || this.getHunger() <= 0) {
                return false;
            }
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 0) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
            }
            entityplayer.field_71071_by.func_70441_a(new ItemStack(Item.field_77729_bt, 1));
            this.setDinoAgeTick(12000);
            this.setHunger(1 + new Random().nextInt(this.getHunger()));
            return true;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != entityplayer)) {
            entityplayer.field_70177_z = this.field_70177_z;
            entityplayer.func_70078_a((Entity)this);
            this.func_70778_a(null);
            this.field_70761_aq = this.field_70177_z;
            return true;
        }
        return false;
    }

    public int func_70641_bl() {
        return 200;
    }

    public boolean isSelfAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public boolean isSelfSitting() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setSelfAngry(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag != this.isSelfAngry()) {
            if (flag) {
                this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 2)));
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 + 0.24 * (double)this.getDinoAge());
            } else {
                this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFD)));
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15 + 0.12 * (double)this.getDinoAge());
            }
        }
    }

    public void setSelfSitting(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFFE)));
        }
    }

    private void InitSize() {
        this.func_70105_a((float)(0.5 + 0.5125 * (double)this.getDinoAge()), (float)(0.5 + 0.5125 * (double)this.getDinoAge()));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.attackStrength = 4 + 2 * this.getDinoAge();
    }

    @Override
    public boolean CheckSpace() {
        if (this.field_70123_F) {
            return false;
        }
        if (!this.func_70090_H()) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.field_70130_N * 0.9f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.9f;
            int j = MathHelper.func_76128_c((double)(this.field_70165_t + (double)f));
            int k = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e() + (double)f1));
            int l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)f2));
            Block block = Block.field_71973_m[this.field_70170_p.func_72798_a(i, j, k)];
            if (block == null) continue;
            if (block == Block.field_71943_B) continue;
            if (block == Block.field_71942_A) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean HandleEating(int FoodValue) {
        if (this.getHunger() >= this.getHungerLimit()) {
            return false;
        }
        this.increaseHunger(FoodValue);
        this.showHeartsOrSmokeFX(false);
        if (this.getHunger() >= this.getHungerLimit()) {
            this.setHunger(this.getHungerLimit());
        }
        return true;
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.getGLY() * 1.5, this.field_70161_v);
    }

    private void Flee(Entity EscapeFrom, int range) {
        int DistanceX = new Random().nextInt(range) + 1;
        int DistanceZ = (int)Math.round(Math.sqrt(Math.pow(range, 2.0) - Math.pow(DistanceX, 2.0)));
        int TargetX = 0;
        int TargetY = 0;
        int TargetZ = 0;
        TargetX = EscapeFrom.field_70165_t <= this.field_70165_t ? (int)Math.round(this.field_70165_t) + DistanceX : (int)Math.round(this.field_70165_t) - DistanceX;
        TargetZ = EscapeFrom.field_70161_v <= this.field_70161_v ? (int)Math.round(this.field_70161_v) + DistanceZ : (int)Math.round(this.field_70161_v) - DistanceZ;
        for (int i = 128; i > 0; --i) {
            if (this.field_70170_p.func_72799_c(TargetX, i, TargetZ)) continue;
            TargetY = i;
            break;
        }
        this.func_70903_f(false);
        this.setSelfSitting(false);
        this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, TargetX, TargetY, TargetZ, (float)range, true, false, true, false));
    }

    private boolean HuntForPrey(int range) {
        if (this.func_70777_m() == null || !(this.func_70777_m() instanceof EntityPlayer)) {
            EntityLivingBase targetLiving = null;
            EntityLivingBase TempLiving2 = null;
            float NearestDistance = (float)range * 2.0f;
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72332_a().func_72299_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b((double)range, (double)(range * 2), (double)range));
            for (EntityLivingBase TempLiving2 : list) {
                if (TempLiving2 instanceof EntityPlayer || !(TempLiving2 instanceof EntitySquid) && !(TempLiving2 instanceof EntityNautilus) || !(this.GetDistanceWithEntity((Entity)TempLiving2) < NearestDistance)) continue;
                NearestDistance = this.GetDistanceWithEntity((Entity)TempLiving2);
                targetLiving = TempLiving2;
            }
            if (targetLiving != null) {
                this.func_70784_b((Entity)targetLiving);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void func_70664_aZ() {
        this.field_70703_bu = false;
    }

    public void heal(int i) {
        if (this.func_110143_aJ() <= 0.0f) {
            return;
        }
        this.func_70606_j(this.func_110143_aJ() + (float)i);
        if (this.func_110143_aJ() > 200.0f) {
            this.func_70606_j(200.0f);
        }
    }

    @Override
    public void ShowPedia(EntityPlayer checker) {
        this.PediaTextCorrection(this.SelfType, checker);
        if (this.func_70909_n()) {
            mod_Fossil.ShowMessage(OwnerText + this.func_70905_p(), checker);
            mod_Fossil.ShowMessage(AgeText + this.getDinoAge(), checker);
            mod_Fossil.ShowMessage(HelthText + this.func_110143_aJ() + "/" + 20, checker);
            mod_Fossil.ShowMessage(HungerText + this.getHunger() + "/" + this.getHungerLimit(), checker);
        } else {
            mod_Fossil.ShowMessage(CautionText, checker);
        }
    }

    @Override
    public String[] additionalPediaMessage() {
        String[] result = null;
        if (!this.func_70909_n()) {
            result = new String[]{UntamedText};
        }
        return result;
    }

    public void HandleBoatSinking() {
        EntityBoat TargetBoat = null;
        List list = this.field_70170_p.func_72872_a(EntityBoat.class, AxisAlignedBB.func_72332_a().func_72299_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(10.0, 4.0, 10.0));
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !(TargetBoat = (EntityBoat)iterator.next()).func_70090_H()) {
        }
        if (TargetBoat != null) {
            if (TargetBoat.field_70153_n != null) {
                TargetBoat.field_70153_n.func_70078_a((Entity)TargetBoat);
            }
            TargetBoat.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 50.0f);
        }
    }

    @Override
    public void SetOrder(EnumOrderType input) {
        this.OrderStatus = input;
    }

    public boolean HandleEating(int FoodValue, boolean FernFlag) {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        return new EntityMosasaurus(this.field_70170_p, 0);
    }

    @Override
    public void updateSize(boolean shouldAddAge) {
    }

    @Override
    public EnumOrderType getOrderType() {
        return this.OrderStatus;
    }

    @Override
    protected int foodValue(Item asked) {
        if (asked == mod_Fossil.SJL) {
            return 50;
        }
        return 0;
    }

    @Override
    public void HoldItem(Item itemGot) {
    }

    @Override
    public float getGLX() {
        return (float)(0.5 + 0.5125 * (double)this.getDinoAge());
    }

    @Override
    public float getGLY() {
        return (float)(0.5 + 0.5125 * (double)this.getDinoAge());
    }
}

