/*
 * Decompiled with CFR 0.152.
 */
package com.voidzm.novamenu.asm;

import com.voidzm.novamenu.asm.NovamenuTransformer;
import java.lang.reflect.Constructor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassMethodVisitor
extends ClassVisitor {
    private String methodToVisit;
    private String descToVisit;
    private Class<? extends MethodVisitor> visitorClass;
    private boolean methodTransformed = false;

    public ClassMethodVisitor(ClassVisitor cv, String method, String desc, Class<? extends MethodVisitor> mvClass) {
        super(262144, cv);
        this.methodToVisit = method;
        this.descToVisit = desc;
        this.visitorClass = mvClass;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.methodTransformed) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (NovamenuTransformer.doVerboseTransformer) {
            System.out.println("Locating method " + this.methodToVisit + " with desc " + this.descToVisit + "; checking " + name + ", " + desc + ".");
        }
        if (!name.equals(this.methodToVisit) || !desc.equals(this.descToVisit)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (NovamenuTransformer.doVerboseTransformer) {
            System.out.println(this.methodToVisit + " located!");
        }
        Constructor<? extends MethodVisitor> visitorConstructor = null;
        try {
            visitorConstructor = this.visitorClass.getConstructor(MethodVisitor.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MethodVisitor target = null;
        try {
            target = visitorConstructor.newInstance(super.visitMethod(access, name, desc, signature, exceptions));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.methodTransformed = true;
        return target;
    }
}

