/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.config.setting;

import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.config.Config;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.Configuration;

public abstract class Setting<T> {
    public final Config config;
    public final T defaultValue;
    public final String fullName;
    public final String name;
    public final String category;
    protected T value;
    protected T syncedValue;
    protected String comment = null;
    private boolean synced = false;

    public Setting(Config config, String fullName, T defaultValue) {
        this.config = config;
        this.defaultValue = defaultValue;
        this.fullName = fullName;
        int dotIndex = fullName.lastIndexOf(46);
        if (dotIndex < 1) {
            throw new IllegalArgumentException("fullName doesn't contain a category.");
        }
        this.name = fullName.substring(dotIndex + 1);
        this.category = fullName.substring(0, dotIndex);
        this.value = defaultValue;
        this.syncedValue = this.value;
        config.add(this);
    }

    public Setting<T> setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Setting<T> setSynced() {
        if (!this.synced) {
            this.synced = true;
            this.config.syncSetting(this);
        }
        return this;
    }

    public T getValue() {
        return this.syncedValue;
    }

    public T getInternalValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.syncedValue = value;
    }

    public void setSyncedValue(T value) {
        this.syncedValue = value;
    }

    protected String validateInternal(T value) {
        return null;
    }

    public void validate() {
        String warning = this.validateInternal(this.getInternalValue());
        if (warning != null) {
            this.setValue(this.defaultValue);
            BetterStorage.log.warning(String.format("Config setting %s is invalid: %s. Using default value: %s.", this.fullName, warning, this.defaultValue));
        }
    }

    public void load(Configuration config) {
        this.setValue(this.loadInternal(config));
    }

    public void save(Configuration config) {
        this.saveInternal(config, this.getInternalValue());
    }

    public void read(NBTTagCompound compound) {
        this.setSyncedValue(this.readInternal(compound));
    }

    public void write(NBTTagCompound compound) {
        this.writeInternal(compound, this.getInternalValue());
    }

    protected abstract T loadInternal(Configuration var1);

    protected abstract void saveInternal(Configuration var1, T var2);

    protected abstract T readInternal(NBTTagCompound var1);

    protected abstract void writeInternal(NBTTagCompound var1, T var2);
}

