/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.locking;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.api.lock.EnumLockInteraction;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.api.lock.ILockable;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemLock
extends ItemBetterStorage
implements ILock {
    private Icon iconColor;
    private Icon iconFullColor;

    public ItemLock(int id) {
        super(id);
        this.func_77656_e(64);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconColor = iconRegister.func_94245_a("betterstorage:lock_color");
        this.iconFullColor = iconRegister.func_94245_a("betterstorage:lock_fullColor");
    }

    public boolean isRepairable() {
        return true;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return material.func_77973_b() == Item.field_77717_p;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int func_77619_b() {
        return 20;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemLock.ensureHasID(stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isBeingHeld) {
        if (!world.field_72995_K) {
            ItemLock.ensureHasID(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        int fullColor = ItemLock.getFullColor(stack);
        if (fullColor < 0) {
            fullColor = 0xFFFFFF;
        }
        if (renderPass > 0) {
            int color = ItemLock.getColor(stack);
            return color < 0 ? fullColor : color;
        }
        return fullColor;
    }

    public Icon getIcon(ItemStack stack, int renderPass) {
        boolean hasFullColor;
        boolean bl = hasFullColor = ItemLock.getFullColor(stack) >= 0;
        if (renderPass > 0 && ItemLock.getColor(stack) >= 0) {
            return this.iconColor;
        }
        return hasFullColor ? this.iconFullColor : this.field_77791_bV;
    }

    public static void ensureHasID(ItemStack stack) {
        if (!StackUtils.has(stack, "id")) {
            ItemLock.setID(stack, RandomUtils.getInt(1, 32000));
        }
    }

    @Override
    public String getLockType() {
        return "normal";
    }

    @Override
    public void onUnlock(ItemStack lock, ItemStack key, ILockable lockable, EntityPlayer player, boolean success) {
        if (success) {
            return;
        }
        EnumLockInteraction interaction = key != null ? EnumLockInteraction.PICK : EnumLockInteraction.OPEN;
        this.applyEffects(lock, lockable, player, interaction);
    }

    @Override
    public void applyEffects(ItemStack lock, ILockable lockable, EntityPlayer player, EnumLockInteraction interaction) {
        int shock = BetterStorageEnchantment.getLevel(lock, "shock");
        int trigger = BetterStorageEnchantment.getLevel(lock, "trigger");
        if (shock > 0) {
            boolean open = interaction == EnumLockInteraction.OPEN;
            boolean pick = interaction == EnumLockInteraction.PICK;
            int damage = shock;
            if (pick) {
                damage *= 3;
            }
            player.func_70097_a(DamageSource.field_76376_m, (float)damage);
            if (shock >= 3 && !open) {
                player.func_70015_d(3);
            }
        }
        if (trigger > 0) {
            lockable.applyTrigger();
        }
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return true;
    }
}

