/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.mcft.copy.betterstorage.content.Items;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.item.recipe.ComboRecipe;
import net.mcft.copy.betterstorage.utils.DyeUtils;
import net.mcft.copy.betterstorage.utils.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class KeyRecipe
extends ComboRecipe {
    private static ItemStack dummyResult = new ItemStack((Item)Items.key);

    public KeyRecipe(int width, int height, ItemStack[] recipe) {
        super(width, height, recipe, dummyResult);
    }

    @Override
    public boolean canMirror() {
        return this.width > 1;
    }

    @Override
    public boolean func_77569_a(InventoryCrafting crafting, World world) {
        if (!super.func_77569_a(crafting, world)) {
            return false;
        }
        int items = 0;
        for (int i = 0; i < crafting.func_70302_i_(); ++i) {
            if (crafting.func_70301_a(i) == null) continue;
            ++items;
        }
        return items > 1;
    }

    @Override
    public boolean checkShapelessItems(InventoryCrafting crafting, List<ItemStack> shapelessItems) {
        List<ItemStack> keys = InventoryUtils.findItems((IInventory)crafting, Items.key);
        if (keys.size() > 1) {
            return false;
        }
        for (ItemStack stack : shapelessItems) {
            if (stack.func_77973_b() == Items.key || DyeUtils.isDye(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting crafting) {
        ItemStack result;
        boolean modifyKey = this.func_77570_a() == 1;
        ItemStack key = InventoryUtils.findItem((IInventory)crafting, Items.key);
        List<ItemStack> dyes = InventoryUtils.findDyes((IInventory)crafting);
        ItemStack itemStack = result = modifyKey ? key.func_77946_l() : new ItemStack((Item)Items.key);
        if (key != null) {
            ItemBetterStorage.setID(result, ItemBetterStorage.getID(key));
        }
        if (dyes.size() > 0) {
            int color = DyeUtils.getColorFromDyes(dyes);
            if (dyes.size() >= 8) {
                ItemBetterStorage.setFullColor(result, color);
            } else {
                ItemBetterStorage.setColor(result, color);
            }
        }
        return result;
    }

    public static KeyRecipe createKeyRecipe(Object ... recipe) {
        int width = 0;
        int height = 0;
        ArrayList<String> recipeStrings = new ArrayList<String>();
        HashMap<Character, ItemStack> itemMap = new HashMap<Character, ItemStack>();
        char lastChar = ' ';
        for (Object obj : recipe) {
            if (obj instanceof String) {
                String str = (String)obj;
                width = Math.max(width, str.length());
                ++height;
                recipeStrings.add(str);
                continue;
            }
            if (obj instanceof Character) {
                lastChar = ((Character)obj).charValue();
                continue;
            }
            if (obj instanceof ItemStack) {
                itemMap.put(Character.valueOf(lastChar), (ItemStack)obj);
                continue;
            }
            if (obj instanceof Item) {
                itemMap.put(Character.valueOf(lastChar), new ItemStack((Item)obj));
                continue;
            }
            if (!(obj instanceof Block)) continue;
            itemMap.put(Character.valueOf(lastChar), new ItemStack((Block)obj));
        }
        ItemStack[] recipeItems = new ItemStack[width * height];
        for (int y = 0; y < height; ++y) {
            String recipeString = (String)recipeStrings.get(y);
            for (int x = 0; x < width; ++x) {
                char chr;
                ItemStack item = null;
                if (x < recipeString.length() && itemMap.containsKey(Character.valueOf(chr = recipeString.charAt(x)))) {
                    item = (ItemStack)itemMap.get(Character.valueOf(chr));
                }
                recipeItems[x + y * width] = item;
            }
        }
        return new KeyRecipe(width, height, recipeItems);
    }
}

