/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.IContainerItem;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemCardboardBox
extends ItemBlock
implements IContainerItem {
    public ItemCardboardBox(int id) {
        super(id);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        if (StackUtils.has(stack, "Items")) {
            ItemStack[] contents = StackUtils.getStackContents(stack, 27);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (ItemStack s : contents) {
                String name;
                if (s == null) continue;
                Integer amount = (Integer)map.get(name = s.func_82833_r());
                map.put(name, (amount != null ? amount : 0) + s.field_77994_a);
            }
            ArrayList items = new ArrayList(map.entrySet());
            Collections.sort(items, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> a, Map.Entry<String, Integer> b) {
                    return b.getValue() - a.getValue();
                }
            });
            int max = advancedTooltips ? 8 : 3;
            for (int i = 0; i < items.size() && i < max; ++i) {
                Map.Entry entry = (Map.Entry)items.get(i);
                list.add(entry.getValue() + "x " + (String)entry.getKey());
            }
            int more = 0;
            for (int i = max; i < items.size(); ++i) {
                more += ((Integer)((Map.Entry)items.get(i)).getValue()).intValue();
            }
            if (more > 0) {
                list.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + LanguageUtils.translateTooltip("cardboardBox.more." + (more == 1 ? "1" : "x"), "%X%", Integer.toString(more)));
            }
        } else if (BetterStorage.globalConfig.getBoolean("settings.enableHelpTooltips")) {
            list.add(LanguageUtils.translateTooltip("cardboardBox.useHint" + (ItemCardboardBox.isReusable() ? ".reusable" : ""), new String[0]));
        }
    }

    @Override
    public ItemStack[] getContainerItemContents(ItemStack container) {
        if (StackUtils.has(container, "Items")) {
            return StackUtils.getStackContents(container, ItemCardboardBox.getRows());
        }
        return null;
    }

    @Override
    public boolean canBeStoredInContainerItem(ItemStack item) {
        return !StackUtils.has(item, "Items");
    }

    public static int getRows() {
        return BetterStorage.globalConfig.getInteger("settings.cardboardBoxRows");
    }

    public static boolean isReusable() {
        return BetterStorage.globalConfig.getBoolean("settings.cardboardBoxReusable");
    }
}

