/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntityConnectable
extends TileEntityContainer
implements IInventory {
    private ForgeDirection orientation = ForgeDirection.UNKNOWN;
    private ForgeDirection connected = ForgeDirection.UNKNOWN;

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        this.orientation = orientation;
    }

    public ForgeDirection getConnected() {
        return this.connected;
    }

    public void setConnected(ForgeDirection connected) {
        this.connected = connected;
    }

    public abstract ForgeDirection[] getPossibleNeighbors();

    public boolean isConnected() {
        return this.getConnected() != ForgeDirection.UNKNOWN;
    }

    public boolean isMain() {
        ForgeDirection connected = this.getConnected();
        return !this.isConnected() || connected.offsetX + connected.offsetY + connected.offsetZ > 0;
    }

    public TileEntityConnectable getMainTileEntity() {
        if (this.isMain()) {
            return this;
        }
        TileEntityConnectable connectable = this.getConnectedTileEntity();
        if (connectable != null) {
            return connectable;
        }
        if (BetterStorage.globalConfig.getBoolean("settings.enableWarningMessages")) {
            BetterStorage.log.warning(String.format("getConnectedTileEntity() returned null in getMainTileEntity(). Location: %s,%s,%s", this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
        return this;
    }

    public TileEntityConnectable getConnectedTileEntity() {
        if (!this.isConnected()) {
            return null;
        }
        ForgeDirection connected = this.getConnected();
        int x = this.field_70329_l + connected.offsetX;
        int y = this.field_70330_m + connected.offsetY;
        int z = this.field_70327_n + connected.offsetZ;
        return WorldUtils.get((IBlockAccess)this.field_70331_k, x, y, z, TileEntityConnectable.class);
    }

    public boolean canConnect(TileEntityConnectable connectable) {
        return connectable != null && this.func_70311_o() == connectable.func_70311_o() && this.getOrientation() == connectable.getOrientation() && !this.isConnected() && !connectable.isConnected();
    }

    public void checkForConnections() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        TileEntityConnectable connectableFound = null;
        ForgeDirection dirFound = ForgeDirection.UNKNOWN;
        for (ForgeDirection dir : this.getPossibleNeighbors()) {
            int x = this.field_70329_l + dir.offsetX;
            int y = this.field_70330_m + dir.offsetY;
            int z = this.field_70327_n + dir.offsetZ;
            TileEntityConnectable connectable = WorldUtils.get((IBlockAccess)this.field_70331_k, x, y, z, TileEntityConnectable.class);
            if (!this.canConnect(connectable)) continue;
            if (connectableFound != null) {
                return;
            }
            connectableFound = connectable;
            dirFound = dir;
        }
        if (connectableFound == null) {
            return;
        }
        this.setConnected(dirFound);
        connectableFound.setConnected(dirFound.getOpposite());
        this.markForUpdate();
        connectableFound.markForUpdate();
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        TileEntityConnectable connectable = this.getConnectedTileEntity();
        this.setConnected(ForgeDirection.UNKNOWN);
        if (connectable != null) {
            connectable.setConnected(ForgeDirection.UNKNOWN);
            connectable.markForUpdate();
        } else if (BetterStorage.globalConfig.getBoolean("settings.enableWarningMessages")) {
            BetterStorage.log.warning(String.format("getConnectedTileEntity() returned null in disconnect(). Location: %s,%s,%s", this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    protected abstract String getConnectableName();

    @Override
    public final String getName() {
        return this.getConnectableName() + (this.isConnected() ? "Large" : "");
    }

    @Override
    protected boolean doesSyncPlayers() {
        return true;
    }

    @Override
    public InventoryTileEntity getPlayerInventory() {
        TileEntityConnectable connected = this.getConnectedTileEntity();
        if (connected != null) {
            return new InventoryTileEntity((TileEntityContainer)this, this.isMain() ? this : connected, this.isMain() ? connected : this);
        }
        return super.getPlayerInventory();
    }

    @Override
    public final void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.onBlockPlacedBeforeCheckingConnections(player, stack);
        this.checkForConnections();
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        this.disconnect();
    }

    protected void onBlockPlacedBeforeCheckingConnections(EntityLivingBase player, ItemStack stack) {
        this.setOrientation(DirectionUtils.getOrientation((Entity)player).getOpposite());
    }

    protected boolean isAccessible() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        double x = (double)this.field_70329_l + 0.5;
        double y = (double)this.field_70330_m + 0.5;
        double z = (double)this.field_70327_n + 0.5;
        if (this.isConnected()) {
            if (!this.isMain()) {
                return;
            }
            TileEntityConnectable connectable = this.getConnectedTileEntity();
            if (connectable != null) {
                x = (x + (double)connectable.field_70329_l + 0.5) / 2.0;
                z = (z + (double)connectable.field_70327_n + 0.5) / 2.0;
                this.lidAngle = Math.max(this.lidAngle, connectable.lidAngle);
            }
        }
        float pitch = this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f;
        if (this.lidAngle > 0.0f && this.prevLidAngle == 0.0f) {
            this.field_70331_k.func_72908_a(x, y, z, "random.chestopen", 0.5f, pitch);
        }
        if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
            this.field_70331_k.func_72908_a(x, y, z, "random.chestclosed", 0.5f, pitch);
        }
    }

    public String func_70303_b() {
        return this.getName();
    }

    public boolean func_94042_c() {
        return !this.shouldLocalizeTitle();
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.isAccessible() ? this.getPlayerInventory().func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int slot) {
        return this.isAccessible() ? this.getPlayerInventory().func_70301_a(slot) : null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (this.isAccessible()) {
            this.getPlayerInventory().func_70299_a(slot, stack);
        }
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.isAccessible() ? this.getPlayerInventory().func_70298_a(slot, amount) : null;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.isAccessible() ? this.getPlayerInventory().func_94041_b(slot, stack) : false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isAccessible() ? this.getPlayerInventory().func_70300_a(player) : false;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70295_k_() {
        if (this.isAccessible()) {
            this.getPlayerInventory().func_70295_k_();
        }
    }

    public void func_70305_f() {
        if (this.isAccessible()) {
            this.getPlayerInventory().func_70305_f();
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
    }

    public Packet func_70319_e() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("orientation", (byte)this.getOrientation().ordinal());
        compound.func_74774_a("connected", (byte)this.getConnected().ordinal());
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, compound);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        NBTTagCompound compound = packet.field_73331_e;
        this.setOrientation(ForgeDirection.getOrientation((int)compound.func_74771_c("orientation")));
        this.setConnected(ForgeDirection.getOrientation((int)compound.func_74771_c("connected")));
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        this.setOrientation(ForgeDirection.getOrientation((int)compound.func_74771_c("orientation")));
        this.setConnected(ForgeDirection.getOrientation((int)compound.func_74771_c("connected")));
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74774_a("orientation", (byte)this.getOrientation().ordinal());
        compound.func_74774_a("connected", (byte)this.getConnected().ordinal());
    }
}

