/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class NbtUtils {
    private NbtUtils() {
    }

    public static <T> T getTagValue(NBTBase tag) {
        if (tag instanceof NBTTagByte) {
            return (T)Byte.valueOf(((NBTTagByte)tag).field_74756_a);
        }
        if (tag instanceof NBTTagShort) {
            return (T)Short.valueOf(((NBTTagShort)tag).field_74752_a);
        }
        if (tag instanceof NBTTagInt) {
            return (T)Integer.valueOf(((NBTTagInt)tag).field_74748_a);
        }
        if (tag instanceof NBTTagLong) {
            return (T)Long.valueOf(((NBTTagLong)tag).field_74753_a);
        }
        if (tag instanceof NBTTagFloat) {
            return (T)Float.valueOf(((NBTTagFloat)tag).field_74750_a);
        }
        if (tag instanceof NBTTagDouble) {
            return (T)Double.valueOf(((NBTTagDouble)tag).field_74755_a);
        }
        if (tag instanceof NBTTagString) {
            return (T)((NBTTagString)tag).field_74751_a;
        }
        if (tag instanceof NBTTagByteArray) {
            return (T)((NBTTagByteArray)tag).field_74754_a;
        }
        if (tag instanceof NBTTagIntArray) {
            return (T)((NBTTagIntArray)tag).field_74749_a;
        }
        return null;
    }

    public static NBTBase createTag(String name, Object value) {
        if (value instanceof Byte) {
            return new NBTTagByte(name, ((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new NBTTagShort(name, ((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new NBTTagInt(name, ((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new NBTTagLong(name, ((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new NBTTagFloat(name, ((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(name, ((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString(name, (String)value);
        }
        if (value instanceof byte[]) {
            return new NBTTagByteArray(name, (byte[])value);
        }
        if (value instanceof int[]) {
            return new NBTTagIntArray(name, (int[])value);
        }
        return null;
    }

    public static NBTTagList createList(String name, Object ... values) {
        NBTTagList list = new NBTTagList(name);
        for (Object value : values) {
            list.func_74742_a(NbtUtils.createTag(null, value));
        }
        return list;
    }

    public static NBTTagCompound createCompound(String name, Object ... nameValuePairs) {
        NBTTagCompound compound = new NBTTagCompound(name);
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            compound.func_74782_a((String)nameValuePairs[i], NbtUtils.createTag(null, nameValuePairs[i + 1]));
        }
        return compound;
    }

    public static void readItems(ItemStack[] contents, NBTTagList items) {
        int i;
        for (i = 0; i < contents.length; ++i) {
            contents[i] = null;
        }
        for (i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = (NBTTagCompound)items.func_74743_b(i);
            int slot = item.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= contents.length) continue;
            contents[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    public static void readItems(List<ItemStack> list, NBTTagList items) {
        for (int i = 0; i < items.func_74745_c(); ++i) {
            list.add(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)items.func_74743_b(i))));
        }
    }

    public static NBTTagList writeItems(ItemStack[] contents) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            contents[i].func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        return items;
    }
}

