/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.List;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class WorldUtils {
    private WorldUtils() {
    }

    public static AxisAlignedBB getAABB(TileEntity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double x = entity.field_70329_l;
        double y = entity.field_70330_m;
        double z = entity.field_70327_n;
        return AxisAlignedBB.func_72332_a().func_72299_a(x - minX, y - minY, z - minZ, x + maxX + 1.0, y + maxY + 1.0, z + maxZ + 1.0);
    }

    public static AxisAlignedBB getAABB(TileEntity entity, double radius) {
        return WorldUtils.getAABB(entity, radius, radius, radius, radius, radius, radius);
    }

    public static EntityItem spawnItem(World world, double x, double y, double z, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        EntityItem item = new EntityItem(world, x, y, z, stack);
        world.func_72838_d((Entity)item);
        return item;
    }

    public static EntityItem spawnItemWithMotion(World world, double x, double y, double z, ItemStack stack) {
        EntityItem item = WorldUtils.spawnItem(world, x, y, z, stack);
        if (item != null) {
            item.field_70159_w = RandomUtils.getGaussian() * (double)0.05f;
            item.field_70181_x = RandomUtils.getGaussian() * (double)0.05f + (double)0.2f;
            item.field_70179_y = RandomUtils.getGaussian() * (double)0.05f;
        }
        return item;
    }

    public static EntityItem dropStackFromBlock(World world, int x, int y, int z, ItemStack stack) {
        float itemX = (float)x + RandomUtils.getFloat(0.1f, 0.9f);
        float itemY = (float)y + RandomUtils.getFloat(0.1f, 0.9f);
        float itemZ = (float)z + RandomUtils.getFloat(0.1f, 0.9f);
        return WorldUtils.spawnItemWithMotion(world, itemX, itemY, itemZ, stack);
    }

    public static EntityItem dropStackFromBlock(TileEntity te, ItemStack stack) {
        return WorldUtils.dropStackFromBlock(te.field_70331_k, te.field_70329_l, te.field_70330_m, te.field_70327_n, stack);
    }

    public static EntityItem dropStackFromEntity(Entity entity, ItemStack stack, float speed) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player == null) {
            double y = entity.field_70163_u + (double)entity.func_70047_e() - 0.3;
            EntityItem item = WorldUtils.spawnItem(entity.field_70170_p, entity.field_70165_t, y, entity.field_70161_v, stack);
            if (item == null) {
                return null;
            }
            item.field_70293_c = 40;
            float f1 = RandomUtils.getFloat(0.5f);
            float f2 = RandomUtils.getFloat((float)Math.PI * 2);
            item.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            item.field_70181_x = 0.2;
            item.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            return item;
        }
        EntityItem item = player.func_71019_a(stack, true);
        if (item != null) {
            item.field_70159_w *= (double)(speed / 4.0f);
            item.field_70179_y *= (double)(speed / 4.0f);
        }
        return item;
    }

    public static boolean is(IBlockAccess world, int x, int y, int z, int id) {
        return world.func_72798_a(x, y, z) == id;
    }

    public static boolean is(IBlockAccess world, int x, int y, int z, Block block) {
        return WorldUtils.is(world, x, y, z, block.field_71990_ca);
    }

    public static <T> boolean is(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        return tileClass.isInstance(world.func_72796_p(x, y, z));
    }

    public static <T> T get(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        TileEntity t = world.func_72796_p(x, y, z);
        return (T)(tileClass.isInstance(t) ? t : null);
    }

    public static boolean isTileEntityUsableByPlayer(TileEntity entity, EntityPlayer player) {
        return entity.field_70331_k.func_72796_p(entity.field_70329_l, entity.field_70330_m, entity.field_70327_n) == entity && player.func_70092_e((double)entity.field_70329_l + 0.5, (double)entity.field_70330_m + 0.5, (double)entity.field_70327_n + 0.5) <= 64.0;
    }

    public static int syncPlayersUsing(TileEntity te, int playersUsing, IInventory playerInventory) {
        if (!te.field_70331_k.field_72995_K && playersUsing != 0) {
            playersUsing = 0;
            List players = te.field_70331_k.func_72872_a(EntityPlayer.class, WorldUtils.getAABB(te, 5.0));
            for (EntityPlayer player : players) {
                if (!(player.field_71070_bA instanceof ContainerBetterStorage)) continue;
                IInventory inventory = ((ContainerBetterStorage)player.field_71070_bA).inventory;
                if (inventory == playerInventory) {
                    ++playersUsing;
                    continue;
                }
                if (!(inventory instanceof InventoryTileEntity) || ((InventoryTileEntity)inventory).mainTileEntity != te) continue;
                ++playersUsing;
            }
        }
        return playersUsing;
    }

    public static int syncPlayersUsing(TileEntityContainer te, int numUsingPlayers) {
        return WorldUtils.syncPlayersUsing(te, numUsingPlayers, te.getPlayerInventory());
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, float partialTicks) {
        Attachments.playerLocal.set(player);
        double range = player.field_70170_p.field_72995_K ? (double)Minecraft.func_71410_x().field_71442_b.func_78757_d() : ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        Vec3 start = player.field_70170_p.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + 1.62 - (double)player.field_70129_M, player.field_70161_v);
        Vec3 look = player.func_70676_i(1.0f);
        Vec3 end = start.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        MovingObjectPosition target = player.field_70170_p.func_72933_a(start, end);
        Attachments.playerLocal.remove();
        return target;
    }

    public static boolean isBlockReplacable(Block block, World world, int x, int y, int z) {
        return block == null || block == Block.field_72037_aS || block == Block.field_71998_bu || block == Block.field_71962_X || block == Block.field_71961_Y || block.isBlockReplaceable(world, x, y, z);
    }

    public static boolean isBlockReplacable(World world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        return WorldUtils.isBlockReplacable(block, world, x, y, z);
    }
}

