/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.radio;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import openblocks.client.radio.SafeInputStream;

public class IcyURLConnection
extends HttpURLConnection {
    protected Socket socket;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    protected Map<String, List<String>> requestProps;
    protected Map<String, List<String>> headers;
    protected String responseLine;
    private int redirectionLoopCount = 0;

    public IcyURLConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        String redirection;
        if (this.connected) {
            return;
        }
        this.socket = this.createSocket();
        this.socket.connect(new InetSocketAddress(this.url.getHost(), this.url.getPort() != -1 ? this.url.getPort() : this.url.getDefaultPort()), this.getConnectTimeout());
        this.connected = true;
        this.headers = Maps.newHashMap();
        this.outputStream = this.socket.getOutputStream();
        this.inputStream = new SafeInputStream(this.socket.getInputStream());
        this.writeLine("GET " + ("".equals(this.url.getPath()) ? "/" : this.url.getPath()) + " HTTP/1.1");
        this.writeLine("Host: " + this.url.getHost());
        if (this.requestProps != null) {
            for (Map.Entry<String, List<String>> entry : this.requestProps.entrySet()) {
                for (String val : entry.getValue()) {
                    this.writeLine(entry.getKey() + ": " + val);
                }
            }
        }
        this.writeLine("");
        this.responseLine = this.readResponseLine();
        String line = this.readLine();
        while (!Strings.isNullOrEmpty((String)line)) {
            this.parseHeaderLine(line);
            line = this.readLine();
        }
        if (this.instanceFollowRedirects && (redirection = this.getHeaderField("location")) != null && this.redirectionLoopCount++ < 10) {
            this.connected = false;
            this.url = new URL(redirection);
            this.connect();
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public String getHeaderField(String name) {
        List<String> list;
        if (this.headers != null && (list = this.headers.get(name)) != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public String getHeaderField(int n) {
        return n == 0 ? this.responseLine : null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public synchronized void setRequestProperty(String key, String value) {
        if (this.requestProps == null) {
            this.requestProps = Maps.newHashMap();
        }
        this.requestProps.put(key, Lists.newArrayList((Object[])new String[]{value}));
    }

    @Override
    public synchronized void addRequestProperty(String key, String value) {
        ArrayList list;
        if (this.requestProps == null) {
            this.requestProps = Maps.newHashMap();
        }
        if ((list = this.requestProps.get(key)) == null) {
            list = Lists.newArrayList();
            this.requestProps.put(key, list);
        }
        list.add(value);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.requestProps;
    }

    @Override
    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        this.inputStream = null;
        this.outputStream = null;
        this.headers = null;
        this.responseLine = null;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    protected Socket createSocket() {
        return new Socket();
    }

    protected void parseHeaderLine(String line) {
        int len = 2;
        int n = line.indexOf(": ");
        if (n == -1) {
            len = 1;
            n = line.indexOf(58);
            if (n == -1) {
                return;
            }
        }
        String key = line.substring(0, n);
        String val = line.substring(n + len);
        List<String> list = this.headers.get(key);
        if (list != null) {
            list.add(val);
        } else {
            this.headers.put(key.toLowerCase(), Lists.newArrayList((Object[])new String[]{val}));
        }
    }

    protected String readResponseLine() throws IOException {
        int n;
        String line = this.readLine();
        if (line != null && (n = line.indexOf(32)) != -1) {
            line = "HTTP/1.0" + line.substring(n);
        }
        return line;
    }

    protected String readLine() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.inputStream.read()) != -1) {
            if (c == 13) continue;
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected void writeLine(String line) throws IOException {
        line = line + "\r\n";
        this.outputStream.write(line.getBytes("UTF-8"));
    }
}

