/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.mutant;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import openblocks.api.IMutant;
import openblocks.api.IMutantRenderer;
import openblocks.utils.MutantUtils;

public class MutantRendererCreeper
implements IMutantRenderer {
    private static final ResourceLocation texture = new ResourceLocation("textures/entity/creeper/creeper.png");
    private ModelRenderer body;
    private ModelRenderer leg1;
    private ModelRenderer leg2;
    private ModelRenderer leg3;
    private ModelRenderer leg4;
    private ModelRenderer head;

    @Override
    public void initialize(ModelBase base) {
        base.field_78090_t = 64;
        base.field_78089_u = 32;
        this.head = new ModelRenderer(base, 0, 0);
        this.head.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.body = new ModelRenderer(base, 16, 16);
        this.body.func_78789_a(-4.0f, 0.0f, -2.0f, 8, 12, 4);
        this.leg1 = new ModelRenderer(base, 0, 16);
        this.leg1.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 6, 4);
        this.leg2 = new ModelRenderer(base, 0, 16);
        this.leg2.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 6, 4);
        this.leg3 = new ModelRenderer(base, 0, 16);
        this.leg3.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 6, 4);
        this.leg4 = new ModelRenderer(base, 0, 16);
        this.leg4.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 6, 4);
    }

    @Override
    public void renderHead(IMutant mutant, float scale, float yaw, float pitch) {
        MutantRendererCreeper.bindTexture();
        MutantUtils.bindToAttachmentPoint(mutant, this.head, mutant.getBody().getHeadAttachmentPoint());
        this.head.field_78795_f = pitch / 57.295776f;
        this.head.field_78796_g = yaw / 57.295776f;
        this.head.func_78785_a(scale);
    }

    @Override
    public void renderLegs(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererCreeper.bindTexture();
        Vec3[] legAttachmentPoints = mutant.getBody().getLegAttachmentPoints(mutant.getLegs().getNumberOfLegs());
        MutantUtils.bindToAttachmentPoint(mutant, this.leg1, legAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg2, legAttachmentPoints[1]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg3, legAttachmentPoints[2]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg4, legAttachmentPoints[3]);
        this.leg1.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 1.4f * prevLegSwing;
        this.leg2.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 1.4f * prevLegSwing;
        this.leg3.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 1.4f * prevLegSwing;
        this.leg4.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 1.4f * prevLegSwing;
        this.leg1.func_78785_a(scale);
        this.leg2.func_78785_a(scale);
        this.leg3.func_78785_a(scale);
        this.leg4.func_78785_a(scale);
    }

    @Override
    public void renderBody(IMutant mutant, float scale) {
        MutantRendererCreeper.bindTexture();
        this.body.func_78793_a(0.0f, 24.0f - (float)mutant.getLegHeight() - (float)mutant.getBodyHeight(), 0.0f);
        this.body.func_78785_a(scale);
    }

    @Override
    public void renderWings(IMutant mutant, float scale, float wingSwing) {
    }

    @Override
    public void renderArms(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    @Override
    public void renderTail(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    private static void bindTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }
}

