/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityFlag;
import openmods.block.OpenBlock;

public class BlockFlag
extends OpenBlock {
    public static final int[] COLORS = new int[16];

    private static void setColor(int index, int red, int green, int blue) {
        BlockFlag.COLORS[index] = red % 256 << 16 | green % 256 << 8 | blue % 256;
    }

    public BlockFlag() {
        super(Config.blockFlagId, Material.field_76248_c);
        this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.0625f);
        this.setRotationMode(OpenBlock.BlockRotationMode.SIX_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
        this.setInventoryRenderRotation(ForgeDirection.DOWN);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean shouldRenderBlock() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileEntityFlag flag = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityFlag.class));
        if (flag != null) {
            ForgeDirection onSurface = flag.getSurfaceDirection();
            if (onSurface == ForgeDirection.DOWN) {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.0625f);
            } else if (onSurface == ForgeDirection.EAST || onSurface == ForgeDirection.WEST) {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.3125f, 1.0f, 0.0625f);
            } else {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.3125f);
            }
        }
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            int belowBlockId = world.func_72798_a(x, y - 1, z);
            Block belowBlock = Block.field_71973_m[belowBlockId];
            if (belowBlock != null) {
                TileEntityFlag flag;
                if (belowBlock == Block.field_72031_aZ) {
                    return true;
                }
                if (belowBlock == this && (flag = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (int)x, (int)(y - 1), (int)z, TileEntityFlag.class))) != null && flag.getSurfaceDirection().equals((Object)ForgeDirection.DOWN)) {
                    return true;
                }
            }
        } else if (side == ForgeDirection.UP) {
            return false;
        }
        return BlockFlag.isNeighborBlockSolid((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return Block.field_71988_x.func_71858_a(par1, par2);
    }

    static {
        BlockFlag.setColor(0, 20, 198, 0);
        BlockFlag.setColor(1, 41, 50, 156);
        BlockFlag.setColor(2, 221, 0, 0);
        BlockFlag.setColor(3, 255, 174, 201);
        BlockFlag.setColor(4, 185, 122, 87);
        BlockFlag.setColor(5, 181, 230, 29);
        BlockFlag.setColor(6, 0, 162, 232);
        BlockFlag.setColor(7, 128, 0, 64);
        BlockFlag.setColor(8, 255, 242, 0);
        BlockFlag.setColor(9, 255, 127, 39);
        BlockFlag.setColor(10, 255, 45, 45);
        BlockFlag.setColor(11, 255, 23, 151);
        BlockFlag.setColor(12, 195, 195, 195);
        BlockFlag.setColor(13, 163, 73, 164);
        BlockFlag.setColor(14, 0, 0, 0);
        BlockFlag.setColor(15, 255, 255, 255);
    }
}

