/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.tileentity.TileEntityImaginary;
import openmods.item.ItemOpenBlock;
import openmods.utils.BlockUtils;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;

public class ItemImaginary
extends ItemOpenBlock {
    public static final float CRAFTING_COST = 1.0f;
    public static final String TAG_COLOR = "Color";
    public static final String TAG_USES = "Uses";
    public static final String TAG_MODE = "Mode";
    public static final int DAMAGE_PENCIL = 0;
    public static final int DAMAGE_CRAYON = 1;
    private Icon iconCrayonBackground;
    private Icon iconCrayonColor;
    private Icon iconPencil;

    public static float getUses(NBTTagCompound tag) {
        NBTBase value = tag.func_74781_a(TAG_USES);
        if (value instanceof NBTTagInt) {
            return ((NBTTagInt)value).field_74748_a;
        }
        if (value instanceof NBTTagFloat) {
            return ((NBTTagFloat)value).field_74750_a;
        }
        throw new IllegalStateException("Invalid tag type: " + value);
    }

    public static float getUses(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return ItemImaginary.getUses(tag);
    }

    public static PlacementMode getMode(NBTTagCompound tag) {
        byte value = tag.func_74771_c(TAG_MODE);
        return PlacementMode.VALUES[value];
    }

    public static PlacementMode getMode(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return ItemImaginary.getMode(tag);
    }

    public static boolean isCrayon(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    public ItemImaginary(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public static ItemStack setupValues(Integer color, ItemStack result) {
        return ItemImaginary.setupValues(color, result, Config.imaginaryItemUseCount);
    }

    public static ItemStack setupValues(Integer color, ItemStack result, float uses) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
        if (color != null) {
            tag.func_74768_a(TAG_COLOR, color.intValue());
            result.func_77964_b(1);
        }
        tag.func_74776_a(TAG_USES, uses);
        return result;
    }

    protected void afterBlockPlaced(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        NBTTagInt color = (NBTTagInt)tag.func_74781_a(TAG_COLOR);
        PlacementMode mode = ItemImaginary.getMode(tag);
        TileEntityImaginary.ICollisionData collisions = mode.createCollisionData(stack, player);
        world.func_72837_a(x, y, z, (TileEntity)new TileEntityImaginary(color == null ? null : Integer.valueOf(color.field_74748_a), mode.isInverted, collisions));
        if (!player.field_71075_bZ.field_75098_d) {
            float uses = Math.max(ItemImaginary.getUses(tag) - mode.cost, 0.0f);
            tag.func_74776_a(TAG_USES, uses);
            if (uses <= 0.0f) {
                stack.field_77994_a = 0;
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (stack == null) {
            return false;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        float uses = ItemImaginary.getUses(tag);
        if (uses <= 0.0f) {
            stack.field_77994_a = 0;
            return true;
        }
        if (uses < ItemImaginary.getMode((NBTTagCompound)tag).cost) {
            return false;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public String func_77667_c(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return tag.func_74764_b(TAG_COLOR) ? "item.openblocks.crayon" : "item.openblocks.pencil";
    }

    public String func_77658_a() {
        return "item.openblocks.imaginary";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List result, boolean extended) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        result.add(StatCollector.func_74837_a((String)"openblocks.misc.uses", (Object[])new Object[]{Float.valueOf(ItemImaginary.getUses(tag))}));
        NBTTagInt color = (NBTTagInt)tag.func_74781_a(TAG_COLOR);
        if (color != null) {
            result.add(StatCollector.func_74837_a((String)"openblocks.misc.color", (Object[])new Object[]{color.field_74748_a}));
        }
        PlacementMode mode = ItemImaginary.getMode(tag);
        String translatedMode = StatCollector.func_74838_a((String)mode.name);
        result.add(StatCollector.func_74837_a((String)"openblocks.misc.mode", (Object[])new Object[]{translatedMode}));
    }

    public void func_77633_a(int id, CreativeTabs tab, List result) {
        result.add(ItemImaginary.setupValues(null, new ItemStack((Item)this, 1, 0)));
        for (ColorUtils.ColorMeta color : ColorUtils.getAllColors()) {
            result.add(ItemImaginary.setupValues(color.rgb, new ItemStack((Item)this, 1, 1)));
        }
    }

    public int func_94901_k() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister registry) {
        this.iconCrayonBackground = registry.func_94245_a("openblocks:crayon_1");
        this.iconCrayonColor = registry.func_94245_a("openblocks:crayon_2");
        this.iconPencil = registry.func_94245_a("openblocks:pencil");
        for (PlacementMode mode : PlacementMode.VALUES) {
            mode.overlay = registry.func_94245_a(mode.overlayName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final Icon getIcon(ItemStack stack, int pass) {
        if (!ItemImaginary.isCrayon(stack)) {
            return pass == 1 ? ItemImaginary.getMode((ItemStack)stack).overlay : this.iconPencil;
        }
        switch (pass) {
            case 0: {
                return this.iconCrayonBackground;
            }
            case 1: {
                return this.iconCrayonColor;
            }
            case 2: {
                return ItemImaginary.getMode((ItemStack)stack).overlay;
            }
        }
        throw new IllegalArgumentException("Invalid pass: " + pass);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (ItemImaginary.isCrayon(stack) && pass == 1) {
            return ItemUtils.getInt((ItemStack)stack, (String)TAG_COLOR);
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return metadata == 1 ? 3 : 2;
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    public boolean func_77634_r() {
        return true;
    }

    public ItemStack getContainerItemStack(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)copy);
        float uses = Math.max(ItemImaginary.getUses(tag) - 1.0f, 0.0f);
        tag.func_74776_a(TAG_USES, uses);
        return copy;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        if (ItemImaginary.getUses(tag) <= 0.0f) {
            stack.field_77994_a = 0;
        } else if (player.func_70093_af()) {
            byte modeId = tag.func_74771_c(TAG_MODE);
            modeId = (byte)((modeId + 1) % PlacementMode.VALUES.length);
            tag.func_74774_a(TAG_MODE, modeId);
            if (world.field_72995_K) {
                PlacementMode mode = PlacementMode.VALUES[modeId];
                ChatMessageComponent modeName = ChatMessageComponent.func_111077_e((String)mode.name);
                player.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.mode", (Object[])new Object[]{modeName}));
            }
        }
        return stack;
    }

    private static enum PlacementMode {
        BLOCK(1.0f, "block", "overlay_block", false){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                return TileEntityImaginary.DUMMY;
            }
        }
        ,
        PANEL(0.5f, "panel", "overlay_panel", false){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                return new TileEntityImaginary.PanelData(1.0f);
            }
        }
        ,
        HALF_PANEL(0.5f, "half_panel", "overlay_half", false){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                return new TileEntityImaginary.PanelData(0.5f);
            }
        }
        ,
        STAIRS(0.75f, "stairs", "overlay_stairs", false){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                ForgeDirection dir = BlockUtils.get2dOrientation((EntityLivingBase)player);
                return new TileEntityImaginary.StairsData(0.5f, 1.0f, dir);
            }
        }
        ,
        INV_BLOCK(1.5f, "inverted_block", "overlay_inverted_block", true){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                return TileEntityImaginary.DUMMY;
            }
        }
        ,
        INV_PANEL(1.0f, "inverted_panel", "overlay_inverted_panel", true){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                return new TileEntityImaginary.PanelData(1.0f);
            }
        }
        ,
        INV_HALF_PANEL(1.0f, "inverted_half_panel", "overlay_inverted_half", true){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                return new TileEntityImaginary.PanelData(0.5f);
            }
        }
        ,
        INV_STAIRS(1.25f, "inverted_stairs", "overlay_inverted_stairs", true){

            @Override
            public TileEntityImaginary.ICollisionData createCollisionData(ItemStack stack, EntityPlayer player) {
                ForgeDirection dir = BlockUtils.get2dOrientation((EntityLivingBase)player);
                return new TileEntityImaginary.StairsData(0.5f, 1.0f, dir);
            }
        };

        public final float cost;
        public final String name;
        public final String overlayName;
        public final boolean isInverted;
        public Icon overlay;
        public static final PlacementMode[] VALUES;

        private PlacementMode(float cost, String name, String overlayName, boolean isInverted) {
            this.cost = cost;
            this.name = "openblocks.misc.mode." + name;
            this.overlayName = "openblocks:" + overlayName;
            this.isInverted = isInverted;
        }

        public abstract TileEntityImaginary.ICollisionData createCollisionData(ItemStack var1, EntityPlayer var2);

        static {
            VALUES = PlacementMode.values();
        }
    }
}

