/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import openmods.api.IPlaceAwareTile;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFloat;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityFan
extends SyncedTileEntity
implements IPlaceAwareTile {
    private SyncableFloat angle;

    protected void createSyncedFields() {
        this.angle = new SyncableFloat(0.0f);
    }

    public void func_70316_g() {
        List entities = this.field_70331_k.func_72872_a(Entity.class, this.getEntitySearchBoundingBox());
        Vec3 blockPos = this.getBlockPosition();
        for (Entity entity : entities) {
            Vec3 entityPos = this.getEntityPosition(entity);
            Vec3 basePos = this.getConeBaseCenter();
            double dX = entityPos.field_72450_a - blockPos.field_72450_a;
            double dY = entityPos.field_72448_b - blockPos.field_72448_b;
            double dZ = entityPos.field_72449_c - blockPos.field_72449_c;
            double dist = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
            if (!this.isLyingInCone(entityPos, blockPos, basePos, 1.2f)) continue;
            double yaw = Math.atan2(dZ, dX) - 1.5707963267948966;
            float pitch = (float)(-Math.atan2(dY, dist));
            double f1 = MathHelper.func_76134_b((float)((float)(-yaw)));
            double f2 = MathHelper.func_76126_a((float)((float)(-yaw)));
            double f3 = -MathHelper.func_76134_b((float)(-pitch));
            double f4 = MathHelper.func_76126_a((float)(-pitch));
            Vec3 directionVec = this.field_70331_k.func_82732_R().func_72345_a(f2 * f3, f4, f1 * f3);
            double force = 1.0 - dist / 10.0;
            force = Math.max(0.0, force);
            entity.field_70159_w -= force * directionVec.field_72450_a * 0.05;
            entity.field_70179_y -= force * directionVec.field_72449_c * 0.05;
        }
    }

    public Vec3 getEntityPosition(Entity entity) {
        return this.field_70331_k.func_82732_R().func_72345_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Vec3 getConeBaseCenter() {
        double angle = Math.toRadians(this.getAngle() - 90.0f);
        return this.field_70331_k.func_82732_R().func_72345_a((double)this.field_70329_l + Math.cos(angle) * 10.0, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + Math.sin(angle) * 10.0);
    }

    public Vec3 getBlockPosition() {
        double angle = Math.toRadians(this.getAngle() - 90.0f);
        return this.field_70331_k.func_82732_R().func_72345_a((double)this.field_70329_l + 0.5 - Math.cos(angle) * 1.1, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5 - Math.sin(angle) * 1.1);
    }

    public AxisAlignedBB getEntitySearchBoundingBox() {
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)(this.field_70330_m - 2), (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 1));
        return boundingBox.func_72314_b(10.0, 10.0, 10.0);
    }

    public boolean isLyingInCone(Vec3 point, Vec3 t, Vec3 b, float aperture) {
        Vec3 axisVect;
        boolean isInInfiniteCone;
        float halfAperture = aperture / 2.0f;
        Vec3 apexToXVect = TileEntityFan.dif(t, point);
        boolean bl = isInInfiniteCone = apexToXVect.func_72430_b(axisVect = TileEntityFan.dif(t, b)) / apexToXVect.func_72433_c() / axisVect.func_72433_c() > Math.cos(halfAperture);
        if (!isInInfiniteCone) {
            return false;
        }
        boolean isUnderRoundCap = apexToXVect.func_72430_b(axisVect) / axisVect.func_72433_c() < axisVect.func_72433_c();
        return isUnderRoundCap;
    }

    public static Vec3 dif(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)(a.field_72450_a - b.field_72450_a), (double)(a.field_72448_b - b.field_72448_b), (double)(a.field_72449_c - b.field_72449_c));
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.angle.setValue(player.field_70759_as);
        this.sync();
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public float getAngle() {
        return this.angle.getValue();
    }
}

