/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.TrophyHandler;
import openmods.api.IActivateAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityTrophy
extends SyncedTileEntity
implements IPlaceAwareTile,
IActivateAwareTile {
    public static TrophyHandler.Trophy debugTrophy = TrophyHandler.Trophy.Wolf;
    private int sinceLastActivate = 0;
    private SyncableInt trophyIndex;

    protected void createSyncedFields() {
        this.trophyIndex = new SyncableInt(-1);
    }

    public TrophyHandler.Trophy getTrophy() {
        int trophyId = this.trophyIndex.getValue();
        return trophyId >= 0 ? TrophyHandler.Trophy.VALUES[trophyId] : null;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            TrophyHandler.Trophy trophy = this.getTrophy();
            if (trophy != null) {
                trophy.executeTickBehavior(this);
            }
            if (this.sinceLastActivate < Integer.MAX_VALUE) {
                ++this.sinceLastActivate;
            }
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TrophyHandler.Trophy trophyType;
        if (!this.field_70331_k.field_72995_K && (trophyType = this.getTrophy()) != null) {
            trophyType.playSound(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            trophyType.executeActivateBehavior(this, player);
        }
        return true;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag;
        boolean set = false;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("entity")) {
            String entityKey = tag.func_74779_i("entity");
            this.trophyIndex.setValue(TrophyHandler.Trophy.valueOf(entityKey).ordinal());
            set = true;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (!set) {
                int next = (debugTrophy.ordinal() + 1) % TrophyHandler.Trophy.values().length;
                debugTrophy = TrophyHandler.Trophy.values()[next];
                this.trophyIndex.setValue(debugTrophy.ordinal());
            }
            this.sync();
        }
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        if (tag.func_74764_b("sinceLastActivate")) {
            this.sinceLastActivate = tag.func_74762_e("sinceLastActivate");
        }
    }

    public int sinceLastActivate() {
        return this.sinceLastActivate;
    }

    public void resetActivationTimer() {
        this.sinceLastActivate = 0;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74768_a("sinceLastActivate", this.sinceLastActivate);
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        Preconditions.checkElementIndex((int)metadata, (int)TrophyHandler.Trophy.VALUES.length);
        super.prepareForInventoryRender(block, metadata);
        this.trophyIndex.setValue(metadata);
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }
}

