/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiXPBottler;
import openblocks.common.container.ContainerXPBottler;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.OpenMods;
import openmods.api.IHasGui;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableProgress;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.SidedInventoryAdapter;

public class TileEntityXPBottler
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IExtendable {
    protected static final int TANK_CAPACITY = EnchantmentUtils.XPToLiquidRatio((int)8);
    protected static final ItemStack GLASS_BOTTLE = new ItemStack(Item.field_77729_bt, 1);
    protected static final ItemStack XP_BOTTLE = new ItemStack(Item.field_77809_bD, 1);
    public static final int PROGRESS_TICKS = 40;
    public List<ForgeDirection> surroundingTanks = new ArrayList<ForgeDirection>();
    private final GenericInventory inventory = new GenericInventory("xpbottler", true, 2){

        public boolean func_94041_b(int slot, ItemStack itemstack) {
            if (slot != 0) {
                return false;
            }
            return itemstack.func_77973_b() == Item.field_77729_bt;
        }
    };
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter sided = new SidedInventoryAdapter((IInventory)this.inventory);
    private SyncableProgress progress;
    private SyncableFlags glassSides;
    private SyncableFlags xpBottleSides;
    private SyncableFlags xpSides;
    private SyncableFlags automaticSlots;
    private SyncableTank tank;
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Drain(this.xpSides, (IFluidTank)this.tank);

    protected void createSyncedFields() {
        this.progress = new SyncableProgress(40);
        this.glassSides = new SyncableFlags();
        this.xpBottleSides = new SyncableFlags();
        this.xpSides = new SyncableFlags();
        this.automaticSlots = new SyncableFlags();
        this.tank = new SyncableTank(TANK_CAPACITY, new FluidStack[]{OpenBlocks.XP_FLUID});
    }

    public TileEntityXPBottler() {
        this.sided.registerSlot((Enum)Slots.input, this.glassSides, true, false);
        this.sided.registerSlot((Enum)Slots.output, this.xpBottleSides, false, true);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                this.tank.autoFillFromSides(OpenMods.proxy, 10, (TileEntity)this, this.xpSides);
            }
            if (this.shouldAutoOutput() && this.hasOutputStack()) {
                InventoryUtils.moveItemsToOneOfSides((TileEntity)this, (Enum)Slots.output, (int)1, (SyncableFlags)this.xpBottleSides);
            }
            if (this.shouldAutoInput() && !this.hasGlassInInput()) {
                InventoryUtils.moveItemsFromOneOfSides((TileEntity)this, (ItemStack)GLASS_BOTTLE, (int)1, (Enum)Slots.input, (SyncableFlags)this.glassSides);
            }
            if (!(this.hasSpaceInOutput() && this.hasGlassInInput() && this.isTankFull())) {
                this.progress.reset();
                return;
            }
            if (!this.progress.isComplete()) {
                this.progress.increase();
            } else {
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "openblocks:fill", 0.5f, 0.8f);
                this.inventory.func_70298_a(Slots.input.ordinal(), 1);
                this.tank.drain(this.tank.getFluidAmount(), true);
                if (this.inventory.func_70301_a(Slots.output.ordinal()) == null) {
                    this.inventory.func_70299_a(Slots.output.ordinal(), XP_BOTTLE.func_77946_l());
                } else {
                    ItemStack outputStack = this.inventory.func_70301_a(Slots.output.ordinal()).func_77946_l();
                    ++outputStack.field_77994_a;
                    this.inventory.func_70299_a(Slots.output.ordinal(), outputStack);
                }
                this.progress.reset();
            }
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerXPBottler((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiXPBottler(new ContainerXPBottler((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public SyncableFlags getGlassSides() {
        return this.glassSides;
    }

    public SyncableFlags getXPBottleSides() {
        return this.xpBottleSides;
    }

    public SyncableFlags getXPSides() {
        return this.xpSides;
    }

    public SyncableFlags getAutomaticSlots() {
        return this.automaticSlots;
    }

    public SyncableProgress getProgress() {
        return this.progress;
    }

    public boolean hasOutputStack() {
        ItemStack outputStack = this.inventory.func_70301_a(1);
        return outputStack != null && outputStack.field_77994_a > 0;
    }

    public boolean shouldAutoInput() {
        return this.automaticSlots.get((Enum)AutoSlots.input);
    }

    public boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    public boolean hasGlassInInput() {
        ItemStack inputStack = this.inventory.func_70301_a(Slots.input.ordinal());
        return inputStack != null && inputStack.func_77969_a(GLASS_BOTTLE);
    }

    public boolean hasSpaceInOutput() {
        ItemStack outputStack = this.inventory.func_70301_a(Slots.output.ordinal());
        return outputStack == null || outputStack.func_77969_a(XP_BOTTLE) && outputStack.field_77994_a < outputStack.func_77976_d();
    }

    public boolean isTankFull() {
        return this.tank.getFluidAmount() == this.tank.getCapacity();
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public static enum AutoSlots {
        input,
        output,
        xp;

    }

    public static enum Slots {
        input,
        output;

    }
}

