/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import dan200.computer.api.IComputerAccess;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.MapColor;
import openblocks.common.HeightMapData;
import openblocks.common.tileentity.TileEntityProjector;
import openperipheral.api.Arg;
import openperipheral.api.IMultiReturn;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import org.apache.commons.lang3.ArrayUtils;

public class AdapterProjector
implements IPeripheralAdapter {
    private static IMultiReturn wrap(final Object ... values) {
        return new IMultiReturn(){

            public Object[] getObjects() {
                return values;
            }
        };
    }

    private static int toInt(Object object) {
        return ((Number)object).intValue();
    }

    public Class<?> getTargetClass() {
        return TileEntityProjector.class;
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get current map id")
    public Integer getMapId(IComputerAccess computer, TileEntityProjector projector) {
        int mapId = projector.mapId();
        return mapId >= 0 ? Integer.valueOf(mapId) : null;
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get current map info")
    public Map<String, Object> getMapInfo(IComputerAccess computer, TileEntityProjector projector) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        HashMap result = Maps.newHashMap();
        result.put("center_x", data.centerX);
        result.put("center_z", data.centerZ);
        result.put("scale", data.scale);
        result.put("dimension", data.dimension);
        HashMap layers = Maps.newHashMap();
        for (int i = 0; i < data.layers.length; ++i) {
            HeightMapData.LayerData layerData = data.layers[i];
            layers.put(i, UnsignedBytes.toInt((byte)layerData.alpha));
        }
        result.put("layers", layers);
        return result;
    }

    @LuaMethod(returnType=LuaType.VOID, description="Set current map info", args={@Arg(name="properties", description="Map of properties", type=LuaType.OBJECT)})
    public void setMapInfo(IComputerAccess computer, TileEntityProjector projector, Map<String, Object> args) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        Object value = args.get("center_x");
        if (value != null) {
            data.centerX = AdapterProjector.toInt(value);
        }
        if ((value = args.get("center_z")) != null) {
            data.centerZ = AdapterProjector.toInt(value);
        }
        if ((value = args.get("dimension")) != null) {
            data.dimension = AdapterProjector.toInt(value);
        }
        if ((value = args.get("layers")) != null) {
            Map layers = (Map)value;
            for (Map.Entry e : layers.entrySet()) {
                int index = AdapterProjector.toInt(e.getKey());
                Preconditions.checkElementIndex((int)index, (int)data.layers.length, (String)"layer index");
                HeightMapData.LayerData layerData = data.layers[index];
                layerData.alpha = (byte)AdapterProjector.toInt(e.getValue());
            }
        }
        projector.markMapDirty();
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get displayed map rotation")
    public int getRotation(IComputerAccess computer, TileEntityProjector projector) {
        return projector.rotation();
    }

    @LuaMethod(returnType=LuaType.VOID, description="Rotate displayed map rotation", args={@Arg(name="delta", description="Rotation delta (positive - CW, negative - CCW)", type=LuaType.NUMBER)})
    public void rotate(IComputerAccess computer, TileEntityProjector projector, int delta) {
        projector.rotate(delta);
    }

    @LuaMethod(onTick=false, returnType=LuaType.NUMBER, description="Get height and color of point on map", args={@Arg(name="row", description="Map row (0..63)", type=LuaType.NUMBER), @Arg(name="column", description="Map column (0..63)", type=LuaType.NUMBER), @Arg(name="layer", description="Map layer", type=LuaType.NUMBER)})
    public IMultiReturn getPoint(IComputerAccess computer, TileEntityProjector projector, int row, int column, int layer) {
        Preconditions.checkElementIndex((int)row, (int)64, (String)"row");
        Preconditions.checkElementIndex((int)column, (int)64, (String)"column");
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        Preconditions.checkElementIndex((int)layer, (int)data.layers.length, (String)"layer");
        int index = 64 * row + column;
        HeightMapData.LayerData layerData = data.layers[layer];
        return AdapterProjector.wrap(UnsignedBytes.toInt((byte)layerData.heightMap[index]), layerData.colorMap[index]);
    }

    @LuaMethod(onTick=false, returnType=LuaType.NUMBER, description="Get height and color of point on map", args={@Arg(name="row", description="Map row (0..63)", type=LuaType.NUMBER), @Arg(name="column", description="Map column (0..63)", type=LuaType.NUMBER), @Arg(name="layer", description="Map layer", type=LuaType.NUMBER), @Arg(name="height", description="Point color", type=LuaType.NUMBER), @Arg(name="color", description="Point height", type=LuaType.NUMBER)})
    public void setPoint(IComputerAccess computer, TileEntityProjector projector, int row, int column, int layer, int height, int color) {
        Preconditions.checkElementIndex((int)row, (int)64, (String)"row");
        Preconditions.checkElementIndex((int)column, (int)64, (String)"column");
        Preconditions.checkElementIndex((int)height, (int)256, (String)"height");
        Preconditions.checkElementIndex((int)color, (int)MapColor.field_76281_a.length, (String)"color");
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        Preconditions.checkElementIndex((int)layer, (int)data.layers.length, (String)"layer");
        int index = 64 * row + column;
        HeightMapData.LayerData layerData = data.layers[layer];
        layerData.heightMap[index] = (byte)height;
        layerData.colorMap[index] = (byte)color;
        projector.markMapDirty();
    }

    @LuaMethod(returnType=LuaType.VOID, description="Clear map")
    public void clearMap(IComputerAccess computer, TileEntityProjector projector) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        data.layers = new HeightMapData.LayerData[0];
        projector.markMapDirty();
    }

    @LuaMethod(returnType=LuaType.VOID, description="Clear single layer", args={@Arg(name="layer", description="Map layer", type=LuaType.NUMBER)})
    public void clearLayer(IComputerAccess computer, TileEntityProjector projector, int layer) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        Preconditions.checkElementIndex((int)layer, (int)data.layers.length, (String)"layer");
        HeightMapData.LayerData newLayer = new HeightMapData.LayerData();
        newLayer.alpha = (byte)-1;
        data.layers[layer] = newLayer;
        projector.markMapDirty();
    }

    @LuaMethod(returnType=LuaType.VOID, description="Append layer")
    public void appendLayer(IComputerAccess computer, TileEntityProjector projector) {
        HeightMapData data = projector.getMap();
        Preconditions.checkState((boolean)data.isValid(), (Object)"Map not loaded");
        HeightMapData.LayerData newLayer = new HeightMapData.LayerData();
        newLayer.alpha = (byte)-1;
        data.layers = (HeightMapData.LayerData[])ArrayUtils.add((Object[])data.layers, (Object)newLayer);
        projector.markMapDirty();
    }
}

